cp_95771(QUATERNION) { 
/*  Copyright Matthew Benesi   All Rights Reserved  */
/*  These formulas are only authorized for distribution with ChaosPro */
/*  Derivative works may not be distributed without authors permission   */
/*  2/28/2011 */
parameter real bailout;
parameter quaternion perturb;
parameter quaternion c;
real sx,sx2,sy,sy2,sz,sz2,sw,sv,su;
real nx,nx2,ny,ny2,nz,nz2,nw,nv,nu;
real r,r1,r2,r3,r1b,r2b,r3b,a,b,bail;
parameter int fractaltype,colormode,r2modeB,bmode,amode;
parameter int pixelmode,assignment,zvalue,absmodeyp,absmodeyn,absmodezn,absmodezp,absmodexp,absmodexn;
complex victor,bravo,cramden,ralph;
real cr,ci,cj,ck,cw,cv,cu,i;
real checkvar,theta,phi,tango,whiskey,foxtrot,gamma;
real pixelr,pixeli,pixelj,pixelw,pixelmag,pixelv,pixelu;
parameter real n,checkvarset,checkvarsetA;
parameter bool juliaMode,switch_b,switch_c,switch_d,switch_a,magswitch,radswitch;

	void init(void)
	{   // amode and colormodeB are switched for mag vs. xyz before march 12 2011
		if (fractaltype=="mag vs xyz") {
			if (bmode=="Pi/2") {
				b=pi/2;
			} else if (bmode=="Root 2") {
				b=sqrt(2);
			} else if (bmode=="Golden Ratio"){
				b=(1+sqrt(5))/2;
			} else if (bmode=="Variable"){
				b=checkvarset;
			}
			
				checkvar=(n)*b;
			
			//a=sqrt(8)*(n)^-1;
			if (amode=="b^(3-n)") {
				a=b^(3-n);
			} else if (amode=="b*(n-1)^-1") {
				a=b*(n-1)^-1;
			} else if (amode=="Variable") {
				a=checkvarsetA;
			}
			
			//a=sqrt(n)*(n-1)^-1;
		}
		
		i=1;
		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		
		if (pixelmode=="+ no abs") {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
		} else if (pixelmode=="rotate pixel") {
			pixelr=-part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
			theta=atan2(pixelr+flip(pixeli))+pi/4;			
			phi=atan2(pixelr+flip(pixelj))+pi/4;	
				
			r1=sqrt(pixelr^2+pixeli^2);
			r2=sqrt(pixelr^2+pixelj^2);
			pixelr=r1*cos(theta);
			pixeli=r1*(sin(theta));
			pixelj=r2*sin(phi);
		}  else if (pixelmode=="rotate pixel 2") {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
			r3=(sqr(pixeli)+sqr(pixelj));
			r1=sqrt(sqr(pixelr)+r3);
			r3=sqrt(r3);
			theta=atan2((pixelr)+flip(r3))+pi/4;			
			phi=atan2(pixeli+flip(pixelj))-pi/4;	
			
		
			pixelr=r1*cos(theta);
			
			r1=r1*(sin(theta));
			pixeli=r1*cos(phi);
			pixelj=r1*sin(phi);
		}  else if (pixelmode=="rotate pixel 3") {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
			r3=(sqr(pixeli)+sqr(pixelj));
			r1=sqrt(sqr(pixelr)+r3);
			r3=sqrt(r3);
			theta=atan2((pixelr)+flip(r3));			
			phi=atan2(pixeli+flip(pixelj));	
		
			pixelr=r1*cos(theta+pi/(2*n));
			
			r1=r1*(sin(theta+pi/(2*n)));
			pixeli=r1*cos(phi-pi/(2*n));
			pixelj=r1*sin(phi-pi/(2*n));
		}  else if (pixelmode=="- no abs") {
			pixelr=-part_r(pixel);
			pixeli=-part_i(pixel);
			pixelj=-part_j(pixel);
		} else if (pixelmode=="+y abs") {
			pixelr=part_r(pixel);
			pixeli=abs(part_i(pixel));
			pixelj=part_j(pixel);
		} else if (pixelmode=="-y abs") {
			pixelr=part_r(pixel);
			pixeli=-abs(part_i(pixel));
			pixelj=part_j(pixel);
		} else if (pixelmode=="+z abs") {
			pixelr=part_r(pixel);
			pixeli=(part_i(pixel));
			pixelj=abs(part_j(pixel));
		} else if (pixelmode=="-z abs") {
			pixelr=part_r(pixel);
			pixeli=(part_i(pixel));
			pixelj=-abs(part_j(pixel));
		} else if (pixelmode=="+y +z abs") {
			pixelr=part_r(pixel);
			pixeli=abs(part_i(pixel));
			pixelj=abs(part_j(pixel));
		} else if (pixelmode=="-y +z abs") {
			pixelr=part_r(pixel);
			pixeli=-abs(part_i(pixel));
			pixelj=abs(part_j(pixel));
		} else if (pixelmode=="-y -z abs") {
			pixelr=part_r(pixel);
			pixeli=-abs(part_i(pixel));
			pixelj=-abs(part_j(pixel));
		} else if  (pixelmode=="+y -z abs") {
			pixelr=part_r(pixel);
			pixeli=abs(part_i(pixel));
			pixelj=-abs(part_j(pixel));
		} else if  (pixelmode=="-x -y -z abs") {
			pixelr=-abs(part_r(pixel));
			pixeli=-abs(part_i(pixel));
			pixelj=-abs(part_j(pixel));
		} else if  (pixelmode=="+x +y +z abs") {
			pixelr=abs(part_r(pixel));
			pixeli=abs(part_i(pixel));
			pixelj=abs(part_j(pixel));
		}  else if  (pixelmode=="New Mode 1") {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
			cw=pixelr-pixeli-pixelj;
			cv=pixeli-pixelr-pixelj;
			cu=pixelj-pixelr-pixeli;
			pixelr=cw;
			pixeli=cv;
			pixelj=cu;
		}   else if  (pixelmode=="New Mode 1-") {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
			cw=pixelr-pixeli-pixelj;
			cv=pixeli-pixelr-pixelj;
			cu=pixelj-pixelr-pixeli;
			pixelr=-cw;
			pixeli=-cv;
			pixelj=-cu;
		} else if  (pixelmode=="Exp 2") {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
			cw=pixelr^2-pixeli^2-pixelj^2;
			cv=pixeli^2-pixelr^2-pixelj^2;
			cu=pixelj^2-pixelr^2-pixeli^2;
			pixelr=sqrt(abs(cw));
			pixeli=sqrt(abs(cv));
			pixelj=sqrt(abs(cu));
			if (cw<0) { pixelr=-pixelr;}
			if (cv<0) { pixeli=-pixeli;}
			if (cu<0) { pixelj=-pixelj;}
		}  else if  (pixelmode=="Exp 3") {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
			cw=pixelr^2-pixeli^2-pixelj^2;
			cv=pixeli^2-pixelr^2-pixelj^2;
			cu=pixelj^2-pixelr^2-pixeli^2;
			
			pixelr=sqrt(abs(cw));
			pixeli=sqrt(abs(cv));
			pixelj=sqrt(abs(cu));
			if (cw<0) { pixelr=-pixelr;}
			if (cv<0) { pixeli=-pixeli;}
			if (cu<0) { pixelj=-pixelj;}
			cw=pixelr-pixeli-pixelj;
			cv=pixeli-pixelr-pixelj;
			cu=pixelj-pixelr-pixeli;
			pixelr=cw;
			pixeli=cv;
			pixelj=cu;
		}  else if  (pixelmode=="Exp 3b") {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
			cw=pixelr^2-pixeli^2-pixelj^2;
			cv=pixeli^2-pixelr^2-pixelj^2;
			cu=pixelj^2-pixelr^2-pixeli^2;
			
			pixelr=sqrt(abs(cw));
			pixeli=sqrt(abs(cv));
			pixelj=sqrt(abs(cu));
			//if (cw<0) { pixelr=-pixelr;}
			//if (cv<0) { pixeli=-pixeli;}
			//if (cu<0) { pixelj=-pixelj;}
			cw=pixelr-pixeli-pixelj;
			cv=pixeli-pixelr-pixelj;
			cu=pixelj-pixelr-pixeli;
			pixelr=cw-part_r(pixel);
			pixeli=cv-part_i(pixel);
			pixelj=cu-part_j(pixel);
			
		}
			pixelmag=cabs(pixel);
		
	if (fractaltype=="Type D2" || fractaltype=="Type R2 D2" || fractaltype=="Type D3" || fractaltype=="Type B1" || fractaltype=="Type C1" || fractaltype=="Type C2" || fractaltype=="R2 D2 intraplanar") {	
		if (assignment=="Magnitude") {
			pixelw=sqrt(pixeli^2+pixelj^2);
			pixelv=sqrt(pixelr^2+pixelj^2);
			pixelu=sqrt(pixelr^2+pixeli^2);
			cw=sqrt(ci^2+cj^2);
			cv=sqrt(cr^2+cj^2);
			cu=sqrt(cr^2+ci^2);
		} else if (assignment=="-Magnitude") {
			pixelw=0-sqrt(pixeli^2+pixelj^2);
			pixelv=0-sqrt(pixelr^2+pixelj^2);
			pixelu=0-sqrt(pixelr^2+pixeli^2);
			cw=0-sqrt(ci^2+cj^2);
			cv=0-sqrt(cr^2+cj^2);
			cu=0-sqrt(cr^2+ci^2);
		} else if (assignment=="-,+,+ Magnitude") {
			pixelw=0-sqrt(pixeli^2+pixelj^2);
			pixelv=sqrt(pixelr^2+pixelj^2);
			pixelu=sqrt(pixelr^2+pixeli^2);
			cw=0-sqrt(ci^2+cj^2);
			cv=sqrt(cr^2+cj^2);
			cu=sqrt(cr^2+ci^2);
		} else if (assignment=="-,-,+ Magnitude") {
			pixelw=0-sqrt(pixeli^2+pixelj^2);
			pixelv=0-sqrt(pixelr^2+pixelj^2);
			pixelu=sqrt(pixelr^2+pixeli^2);
			cw=0-sqrt(ci^2+cj^2);
			cv=0-sqrt(cr^2+cj^2);
			cu=sqrt(cr^2+ci^2);
		} else if (assignment=="-,+,- Magnitude") {
			pixelw=0-sqrt(pixeli^2+pixelj^2);
			pixelv=sqrt(pixelr^2+pixelj^2);
			pixelu=0-sqrt(pixelr^2+pixeli^2);
			cw=0-sqrt(ci^2+cj^2);
			cv=sqrt(cr^2+cj^2);
			cu=0-sqrt(cr^2+ci^2);
		} else if (assignment=="+,-,+ Magnitude") {
			pixelw=sqrt(pixeli^2+pixelj^2);
			pixelv=0-sqrt(pixelr^2+pixelj^2);
			pixelu=sqrt(pixelr^2+pixeli^2);
			cw=sqrt(ci^2+cj^2);
			cv=0-sqrt(cr^2+cj^2);
			cu=sqrt(cr^2+ci^2);
		} else if (assignment=="+,-,- Magnitude") {
			pixelw=sqrt(pixeli^2+pixelj^2);
			pixelv=0-sqrt(pixelr^2+pixelj^2);
			pixelu=0-sqrt(pixelr^2+pixeli^2);
			cw=sqrt(ci^2+cj^2);
			cv=0-sqrt(cr^2+cj^2);
			cu=0-sqrt(cr^2+ci^2);
		} else if (assignment=="+,+,- Magnitude") {
			pixelw=sqrt(pixeli^2+pixelj^2);
			pixelv=sqrt(pixelr^2+pixelj^2);
			pixelu=0-sqrt(pixelr^2+pixeli^2);
			cw=sqrt(ci^2+cj^2);
			cv=sqrt(cr^2+cj^2);
			cu=0-sqrt(cr^2+ci^2);
		} else if (assignment=="Linear Sign Magnitude") {
			if (pixelr<0) {
			pixelw=0-sqrt(pixeli^2+pixelj^2);
			} else {
			pixelw=sqrt(pixeli^2+pixelj^2);
			}
			if (pixeli<0) {
			pixelv=0-sqrt(pixelr^2+pixelj^2);
			} else {
			pixelv=sqrt(pixelr^2+pixelj^2);
			}
			if (pixelj<0) {
			
			pixelu=0-sqrt(pixelr^2+pixeli^2);
			} else {
			pixelu=sqrt(pixelr^2+pixeli^2);
			}
			/*  c variable assignments in each one as well */
			if (cr<0) {
			cw=0-sqrt(ci^2+cj^2);
			} else {
			cw=sqrt(ci^2+cj^2);
			}
			if (ci<0) {
			cv=0-sqrt(cr^2+cj^2);
			} else {
			cv=sqrt(cr^2+cj^2);
			}
			if (cj<0) {
			
			cu=0-sqrt(cr^2+ci^2);
			} else {
			cu=sqrt(cr^2+ci^2);
			}
		} else {   /* these variables will be used in all the next assignments  */
			pixelw=pixeli*abs(pixeli)+abs(pixelj)*pixelj;
			pixelv=pixelr*abs(pixelr)+abs(pixelj)*pixelj;
			pixelu=pixelr*abs(pixelr)+abs(pixeli)*pixeli;
			cw=ci*abs(ci)+abs(cj)*cj;
			cv=cr*abs(cr)+abs(cj)*cj;
			cu=cr*abs(cr)+abs(ci)*ci;
		
			if (assignment=="Planar Sign Magnitude") {
			
				if (pixelw<0) {
					pixelw=0-sqrt(pixeli^2+pixelj^2);
					} else {
					pixelw=sqrt(pixeli^2+pixelj^2);
					}
				if (pixelv<0) {
					pixelv=0-sqrt(pixelr^2+pixelj^2);
					} else {
					pixelv=sqrt(pixelr^2+pixelj^2);
					}
				if (pixelu<0) {
					pixelu=0-sqrt(pixelr^2+pixeli^2);
					} else {
					pixelu=sqrt(pixelr^2+pixeli^2);
					}
				if (cw<0) {
					cw=0-sqrt(ci^2+cj^2);
					} else {
					cw=sqrt(ci^2+cj^2);
					}
				if (cv<0) {
					cv=0-sqrt(cr^2+cj^2);
					} else {
					cv=sqrt(cr^2+cj^2);
					}
				if (cu<0) {
					cu=0-sqrt(cr^2+ci^2);
					} else {
					cu=sqrt(cr^2+ci^2);
					}	
					
					
			} else if (assignment=="Complexitude") {
				pixelw=sqrt(abs(pixelw));
				pixelv=sqrt(abs(pixelv));
				pixelu=sqrt(abs(pixelu));
				cw=sqrt(abs(cw));
				cv=sqrt(abs(cv));
				cu=sqrt(abs(cu));
			} else if (assignment=="-Complexitude") {
				pixelw=0-sqrt(abs(pixelw));
				pixelv=0-sqrt(abs(pixelv));
				pixelu=0-sqrt(abs(pixelu));
				cw=0-sqrt(abs(cw));
				cv=0-sqrt(abs(cv));
				cu=0-sqrt(abs(cu));
			} else if (assignment=="Linear Sign Complexitude") {
				if (pixelr<0) {
					pixelw=0-sqrt(abs(pixelw));
					} else {
					pixelw=sqrt(abs(pixelw));
					}
				if (pixeli<0) {
					pixelv=0-sqrt(abs(pixelv));
					} else {
					pixelv=sqrt(abs(pixelv));
					}
				if (pixelj<0) {
					pixelu=0-sqrt(abs(pixelu));
					} else {
					pixelu=sqrt(abs(pixelu));
					}
					
				if (cr<0) {
					cw=0-sqrt(abs(cw));
					} else {
					cw=sqrt(abs(cw));
					}
				if (ci<0) {
					cv=0-sqrt(abs(cv));
					} else {
					cv=sqrt(abs(cv));
					}
				if (cj<0) {
					cu=0-sqrt(abs(cu));
					} else {
					cu=sqrt(abs(cu));
					}
			} else if (assignment=="Planar Sign Complexitude") {
				if (pixelw<0) {
					pixelw=0-sqrt(abs(pixelw));
					} else {
					pixelw=sqrt(abs(pixelw));
					}
				if (pixelv<0) {
					pixelv=0-sqrt(abs(pixelv));
					} else {
					pixelv=sqrt(abs(pixelv));
					}
				if (pixelu<0) {
					pixelu=0-sqrt(abs(pixelu));
					} else {
					pixelu=sqrt(abs(pixelu));
					}
					
				if (cw<0) {
					cw=0-sqrt(abs(cw));
					} else {
					cw=sqrt(abs(cw));
					}
				if (cv<0) {
					cv=0-sqrt(abs(cv));
					} else {
					cv=sqrt(abs(cv));
					}
				if (cu<0) {
					cu=0-sqrt(abs(cu));
					} else {
					cu=sqrt(abs(cu));
					}
			}	
		}
		if (juliaMode) {
			sw=pixelw;
			sv=pixelv;
			su=pixelu;
		} else {
			sw=cw;
			sv=cv;
			su=cu;
		}
	}
		
		if (juliaMode) {
			sx=pixelr;
			sy=pixeli;
			sz=pixelj;
		} else {
			sx=cr;
			sy=ci;
			sz=cj;
		}
		 if (fractaltype=="Type B1" || "Type C1") {
			sx2=(sx);
			sy2=(sy);
			sz2=(sz);
			}
			
			if (fractaltype=="Type C2") {
			sx2=(sx);
			sx=sx2;
			sy2=(sy);
			sy=sy2;
			sz2=(sz);
			sz=sz2;
		}
		
	}
	void loop(void)
	{	
		if (fractaltype=="z-squared") {
			r1=sqr(sy)+sqr(sz);
			
			if (switch_b) {
				nx=(sqr(sx)-r1);
			} else {
				if (sx>sqrt(r1) && pixelr>0) {
					nx=-sqr(sx)+r1;
				} else {
					nx=sqr(sx)-r1;
				}
			}			
			
			if (switch_a) {
				r3=(r1^-.5)*(sx);
				ny=-abs(r3)*2*(sqr(sy)-sqr(sz));
				nz=r3*4*abs(sy)*sz;	
			} else if (switch_c) {
				r3=-(r1^-.5)*(sx);
				ny=-abs(r3)*2*(sqr(sy)-sqr(sz));
				if (sy>abs(sz)) {
					ny=-ny;
				}
				nz=r3*4*abs(sy)*sz;	
			} else if (switch_d) {
				r3=-(r1^-.5)*abs(sx);
				ny=(r3)*2*(sqr(sy)-sqr(sz));
				if (sy>abs(sz)) {
					ny=-ny;
				}
				nz=r3*4*(sy)*sz;	
			} else {
				r3=-(r1^-.5)*abs(sx);
				ny=r3*2*(sqr(sy)-sqr(sz));
				nz=r3*4*sy*sz;
			}
			if (juliaMode) {
				if (r2modeB=="Normal") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
				} else if (r2modeB=="R2 mode 1") {
					sx=sx-nx+cr;
					sy=sy-nz+ci;
					sz=sz-ny+cj;
				} else if (r2modeB=="R2 mode 2") {
					sx=-sx+nx+cr;
					sy=-sy+nz+ci;
					sz=-sz+ny+cj;
				}
			} else {
				
				if (r2modeB=="Normal") {
					sx=nx+(pixelr);
					sy=ny+(pixeli);
					sz=nz+(pixelj);
				} else if (r2modeB=="R2 mode 1") {
					sx=nx+sx+(pixelr);
					sy=nz+sy+(pixeli);
					sz=ny+sz+(pixelj);
				} else if (r2modeB=="R2 mode 2") {
					sx=-nx+sx+pixelr;
					sy=-nz+sy+pixeli;
					sz=-ny+sz+pixelj;
				} else if (r2modeB=="R2 mode 3") {
					sx=(nx+pixelr)*(n-1);
					sy=(ny+(pixeli))*(n-1);
					sz=(nz+(pixelj))*(n-1);
				}
				
			}
			 if (colormode=="Type B") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,nx,ny,nz);
			} else if (colormode=="Normal") {
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Planar") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz);
		}
		else if (fractaltype=="Beautiful Fractal 2") {
		victor=complex(sx,sqrt(sqr(sy)+sqr(sz)));
		bravo=complex(sqrt(sqr(sx)+sqr(sy)),sz);
		cramden=complex(sy,sz);
		
		r1=cabs(cramden)^-n;
		victor=victor^n;
		bravo=bravo^n;
		cramden=cramden^n;
		
		if (switch_d) {
			if (switch_b) {
				if ((sy)>abs(sz)) {
						victor=complex(sx,sqrt(sqr(sy)+sqr(sz)))^n;
				} else {
						victor=complex(sx,-sqrt(sqr(sy)+sqr(sz)))^n;
				}
				nx=part_r(victor);
				nz=-(part_i(bravo));
				ny=(part_i(victor))*(part_r(cramden))*r1;
			} else {
				nx=part_r(bravo);
				ny=-(part_i(bravo));
				nz=(part_i(victor))*abs(part_r(cramden))*r1;
			}
		} else if (switch_c) {
			if (switch_b) {
				nx=part_r(victor);
				ny=-(part_i(bravo));
				nz=-abs(part_i(victor))*part_r(cramden)*r1;
			} else {
				nx=part_r(victor);
				nz=-(part_i(bravo));
				ny=-abs(part_i(victor))*part_r(cramden)*r1;
			}
		} else if (switch_b) {
			nx=part_r(victor);
			nz=-abs(part_i(bravo));
			ny=-abs(part_i(victor)*part_r(cramden))*r1;
		} else {
			nx=part_r(victor);
			ny=-abs(part_i(bravo));
			nz=-abs(part_i(victor)*part_r(cramden))*r1;
		}
		if (juliaMode) {
				if (r2modeB=="Normal") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
				} else if (r2modeB=="R2 mode 1") {
					sx=sx-nx+cr;
					sy=sy-nz+ci;
					sz=sz-ny+cj;
				} else if (r2modeB=="R2 mode 2") {
					sx=-sx+nx+cr;
					sy=-sy+nz+ci;
					sz=-sz+ny+cj;
				}
			} else {
				
				if (r2modeB=="Normal") {
					sx=nx+(pixelr);
					sy=ny+abs(pixeli);
					sz=nz+abs(pixelj);
				} else if (r2modeB=="R2 mode 1") {
					sx=nx+sx+(pixelr);
					sy=nz+sy+abs(pixeli);
					sz=ny+sz+abs(pixelj);
				} else if (r2modeB=="R2 mode 2") {
					sx=-nx+sx+pixelr;
					sy=-nz+sy+pixeli;
					sz=-ny+sz+pixelj;
				} else if (r2modeB=="R2 mode 3") {
					sx=(nx+pixelr)*(n-1);
					sy=(ny+(pixeli))*(n-1);
					sz=(nz+(pixelj))*(n-1);
				}
				
			}
			if (colormode=="Complex 1") {
				z=quaternion(real(bravo),imag(bravo),real(victor),imag(victor));
			} else if (colormode=="Type B") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,nx,ny,nz);
			} else if (colormode=="Normal") {
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Planar") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz);
		
		}
		else if (fractaltype=="Beautiful Fractal 1") {
		victor=complex(sx,sqrt(sqr(sy)+sqr(sz)));
		bravo=complex(sqrt(sqr(sx)+sqr(sy)),sz);
		cramden=complex(sx,sy);
		
		r1=cabs(cramden)^-(n);
		
		victor=victor^n;
		bravo=bravo^n;
		cramden=cramden^n;
		
		if (switch_c) {
			if (switch_d) {
				if (switch_b) {
					nx=-abs(part_i(victor));
					ny=-abs(part_r(bravo));
					nz=-abs(part_i(bravo)*part_r(cramden))*r1;
				} else {
					nx=-abs(part_r(victor));
					ny=-abs(part_i(bravo));
					nz=-abs(part_r(bravo)*part_i(cramden))*r1;
				}
			} else {
				if (switch_b) {
					nx=part_r(victor);
					ny=(part_i(bravo));
					nz=(part_r(bravo))*part_i(cramden)*r1;
				} else {
					nx=part_r(victor);
					nz=-(part_i(bravo));
					ny=(part_r(bravo))*part_i(cramden)*r1;
				}
			}
		} else if (switch_b) {
			nx=abs(part_r(victor));
			if (switch_a) {
				ny=-abs(part_i(bravo));
				nz=-abs(part_r(bravo)*part_i(cramden))*r1;
			} else {
				ny=-abs(part_r(bravo)*part_i(cramden))*r1;
				nz=-abs(part_i(bravo));
			}
		} else {
			nx=(part_r(victor));
			if (switch_a) {
				ny=-abs(part_r(bravo)*part_i(cramden))*r1;
				nz=-abs(part_i(bravo));
			} else {
				nz=-abs(part_r(bravo)*part_i(cramden))*r1;
				ny=-abs(part_i(bravo));
			}
		}
		if (juliaMode) {
				if (r2modeB=="Normal") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
				} else if (r2modeB=="R2 mode 1") {
					sx=sx-nx+cr;
					sy=sy-nz+ci;
					sz=sz-ny+cj;
				} else if (r2modeB=="R2 mode 2") {
					sx=-sx+nx+cr;
					sy=-sy+nz+ci;
					sz=-sz+ny+cj;
				} else if (r2modeB=="R2 mode 3") {
					sx=-sx*.5+nx+cr;
					sy=-sy*.5+nz+ci;
					sz=-sz*.5+ny+cj;
				}
			} else {
				
				if (r2modeB=="Normal") {
					sx=nx+(pixelr);
					sy=ny+abs(pixeli);
					sz=nz+abs(pixelj);
				} else if (r2modeB=="R2 mode 1") {
					sx=nx+sx+(pixelr);
					sy=nz+sy+abs(pixeli);
					sz=ny+sz+abs(pixelj);
				} else if (r2modeB=="R2 mode 2") {
					sx=-nx+sx+pixelr;
					sy=-nz+sy+pixeli;
					sz=-ny+sz+pixelj;
				} else if (r2modeB=="R2 mode 3") {
					sx=nx-sx+(pixelr);
					sy=ny+abs(pixeli);
					sz=nz+abs(pixelj);
				} else if (r2modeB=="R2 mode 4") {
					sx=nx-sx*n^-.5+(pixelr);
					sy=ny+abs(pixeli);
					sz=nz+abs(pixelj);
				}
				
			}
			if (colormode=="Complex 1") {
				z=quaternion(real(bravo),imag(bravo),real(victor),imag(victor));
			} else if (colormode=="Type B") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,nx,ny,nz);
			} else if (colormode=="Normal") {
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Planar") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz);
		
		}
		
			
		else if (fractaltype=="Complex Compound Mandel 3d") {
			r1=sqrt(sqr(sy)+sqr(sz));
			victor=complex(sx,r1);
			bravo=complex(sy,sz);
			
			if (n<11) {
				r3=r1^(n);
			} else if (n==11) {
				r3=sqr(sqr(sqr(r1)))*sqr(r1)*r1;
			} else if (n==13) {
				r3=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*r1;
			} else if (n==15) {
				r3=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*sqr(r1)*r1;
			} else if (n==16) {
				r3=sqr(sqr(sqr(sqr(r1))));
			} else if (n==17) {
				r3=sqr(sqr(sqr(sqr(r1))))*r1;
			}  else {
				r3=r1^n;
			} 
			r3=r3^(-1);
			if (!switch_a) {
			if (n<11) {
				victor=victor^n;
			} else if (n==11) {
				victor=sqr(sqr(sqr(victor)))*sqr(victor)*victor;
			} else if (n==13) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*victor;
			} else if (n==15) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*sqr(victor)*victor;
			} else if (n==16) {
				victor=sqr(sqr(sqr(sqr(victor))));
			} else if (n==17) {
				victor=sqr(sqr(sqr(sqr(victor))))*victor;
			}  else {
				victor=victor^n;
			} 
			if (n<11) {
				bravo=bravo^n;
			} else if (n==11) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(bravo)*bravo;
			} else if (n==13) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*bravo;
			} else if (n==15) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*sqr(bravo)*bravo;
			} else if (n==16) {
				bravo=sqr(sqr(sqr(sqr(bravo))));
			} else if (n==17) {
				bravo=sqr(sqr(sqr(sqr(bravo))))*bravo;
			}  else {
				bravo=bravo^n;
			} 
				nx=part_r(victor);
				if (n==2 || n==6 || n==10) {
					if (sx>(r1) && pixelr>0) {
						nx=-nx;
					}
				} else if (switch_b && (n==3 || n==5 || n==7 || n==9 || n==11)) {
					if (sx>(0)) {
						nx=-nx;
					}
				}
				r3=-abs(part_i(victor))*r3;
				ny=part_r(bravo)*r3;
				nz=part_i(bravo)*r3;			
			} else {
				
				
				victor=complex(sx,r1)^n;
				r3=r1^-n;
				bravo=complex(sy,sz)^n;
				nx=part_r(victor);
				r3=abs(part_i(victor))*r3;
				if (n==2 || n==6) {
					if (sx>(r1) && pixelr>0) {
						nx=-nx;
					}
					if ((sy)>abs(sz)) {
						ny= -part_r(bravo)*r3;
						} else {
						ny=part_r(bravo)*r3;
						}
				} else {
					ny=part_r(bravo)*r3;
				}
				nz= part_i(bravo)*r3;
					
			}
			 
			
			if (juliaMode) {
				if (r2modeB=="Normal") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
				} else if (r2modeB=="R2 mode 1") {
					sx=sx-nx+cr;
					sy=abs(sy)+ny+ci;
					sz=abs(sz)+nz+cj;
				} else if (r2modeB=="R2 mode 2") {
					sx=-sx+nx+cr;
					sy=-sy+ny+ci;
					sz=-sz+nz+cj;
				}
			} else {
				
				if (r2modeB=="Normal") {
					sx=nx+(pixelr);
					sy=ny+(pixeli);
					sz=nz+(pixelj);
				} else if (r2modeB=="R2 mode 1") {
					sx=nx+sx+(pixelr);
					sy=ny+sy+(pixeli);
					sz=nz+sz+(pixelj);
				} else if (r2modeB=="R2 mode 2") {
					sx=nx+sx+pixelr;
					sy=ny-sy+(pixeli);
					sz=nz-sz+(pixelj);
				} else if (r2modeB=="R2 mode 3") {
					sx=nx+sx*(pixelr)+pixelr;
					sy=ny+sy*(pixeli)+(pixeli);
					sz=nz+sz*(pixelj)+(pixelj);
				}
				
			}
			if (colormode=="Complex 1") {
				z=quaternion(real(bravo),imag(bravo),real(victor),imag(victor));
			} else if (colormode=="Type B") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,nx,ny,nz);
			} else if (colormode=="Normal") {
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Planar") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz);
			
		}
		else if (fractaltype=="Complex Compound Double BS") {
			r1=sqrt(sqr(sy)+sqr(sz));
			victor=complex(sx,r1);
			bravo=complex(sy,sz);
			
			if (n<11) {
				r3=r1^(n);
			} else if (n==11) {
				r3=sqr(sqr(sqr(r1)))*sqr(r1)*r1;
			} else if (n==13) {
				r3=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*r1;
			} else if (n==15) {
				r3=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*sqr(r1)*r1;
			} else if (n==16) {
				r3=sqr(sqr(sqr(sqr(r1))));
			} else if (n==17) {
				r3=sqr(sqr(sqr(sqr(r1))))*r1;
			}  else {
				r3=r1^n;
			} 
			r3=r3^(-1);
		
			if (n<11) {
				victor=victor^n;
			} else if (n==11) {
				victor=sqr(sqr(sqr(victor)))*sqr(victor)*victor;
			} else if (n==13) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*victor;
			} else if (n==15) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*sqr(victor)*victor;
			} else if (n==16) {
				victor=sqr(sqr(sqr(sqr(victor))));
			} else if (n==17) {
				victor=sqr(sqr(sqr(sqr(victor))))*victor;
			}  else {
				victor=victor^n;
			} 
			if (n<11) {
				bravo=bravo^n;
			} else if (n==11) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(bravo)*bravo;
			} else if (n==13) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*bravo;
			} else if (n==15) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*sqr(bravo)*bravo;
			} else if (n==16) {
				bravo=sqr(sqr(sqr(sqr(bravo))));
			} else if (n==17) {
				bravo=sqr(sqr(sqr(sqr(bravo))))*bravo;
			}  else {
				bravo=bravo^n;
			} 
			
				if (switch_b) {
					nx=abs(part_r(victor));
					r3=part_i(victor)*r3;
				} else if (switch_c) {
					nx=abs(part_i(victor));
					r3=part_r(victor)*r3;
				} else {
					nx=part_r(victor);
					r3=part_i(victor)*r3;
				}
				
				if (switch_a) {
					ny=abs(r3*part_i(bravo));
					nz=abs(r3*part_r(bravo));
				} else {
					ny=abs(r3*part_r(bravo));
					nz=abs(r3*part_i(bravo));
				}
			if (juliaMode) {
				if (r2modeB=="Normal") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
				} else if (r2modeB=="R2 mode 1") {
					sx=sx-nx+cr;
					sy=abs(sy)+ny+ci;
					sz=abs(sz)+nz+cj;
				} else if (r2modeB=="R2 mode 2") {
					sx=-sx+nx+cr;
					sy=-sy+ny+ci;
					sz=-sz+nz+cj;
				}
			} else {
				
				if (r2modeB=="Normal") {
					sx=nx+(pixelr);
					sy=ny+(pixeli);
					sz=nz+(pixelj);
				} else if (r2modeB=="R2 mode 1") {
					sx=nx+sx+(pixelr);
					sy=ny+sy+(pixeli);
					sz=nz+sz+(pixelj);
				} else if (r2modeB=="R2 mode 2") {
					sx=nx+sx+pixelr;
					sy=ny-sy+(pixeli);
					sz=nz-sz+(pixelj);
				} else if (r2modeB=="R2 mode 3") {
					sx=nx+sx*(pixelr)+pixelr;
					sy=ny+sy*abs(pixeli)+abs(pixeli);
					sz=nz+sz*abs(pixelj)+abs(pixelj);
				}
				
			}
			if (colormode=="Complex 1") {
				z=quaternion(real(bravo),imag(bravo),real(victor),imag(victor));
			} else if (colormode=="Type B") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,nx,ny,nz);
			} else if (colormode=="Normal") {
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Planar") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz);
			
		}
		  else if (fractaltype=="Complex Compound") {
			r1=sqrt(sqr(sy)+sqr(sz));
			
				victor=complex(sx,r1);
			
			
			bravo=complex(sy,sz);
			
			if (n<11) {
				r3=r1^(n);
			} else if (n==11) {
				r3=sqr(sqr(sqr(r1)))*sqr(r1)*r1;
			} else if (n==13) {
				r3=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*r1;
			} else if (n==15) {
				r3=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*sqr(r1)*r1;
			} else if (n==16) {
				r3=sqr(sqr(sqr(sqr(r1))));
			} else if (n==17) {
				r3=sqr(sqr(sqr(sqr(r1))))*r1;
			}  else {
				r3=r1^n;
			} 
			r3=r3^(-1);
			
			if (n<11) {
				victor=victor^n;
			} else if (n==11) {
				victor=sqr(sqr(sqr(victor)))*sqr(victor)*victor;
			} else if (n==13) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*victor;
			} else if (n==15) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*sqr(victor)*victor;
			} else if (n==16) {
				victor=sqr(sqr(sqr(sqr(victor))));
			} else if (n==17) {
				victor=sqr(sqr(sqr(sqr(victor))))*victor;
			}  else {
				victor=victor^n;
			} 
			if (n<11) {
				bravo=bravo^n;
			} else if (n==11) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(bravo)*bravo;
			} else if (n==13) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*bravo;
			} else if (n==15) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*sqr(bravo)*bravo;
			} else if (n==16) {
				bravo=sqr(sqr(sqr(sqr(bravo))));
			} else if (n==17) {
				bravo=sqr(sqr(sqr(sqr(bravo))))*bravo;
			}  else {
				bravo=bravo^n;
			} 
			
				r3=(part_i(victor)*r3);
				nx=part_r(victor);
				ny=r3*(part_r(bravo));
				nz=r3*(part_i(bravo));  
			
			if (juliaMode) {
				if (r2modeB=="Normal") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
				} else if (r2modeB=="R2 mode 1") {
					sx=sx-nx+cr;
					sy=sy-ny+ci;
					sz=sz-nz+cj;
				} else if (r2modeB=="R2 mode 2") {
					sx=-sx+nx+cr;
					sy=-sy+ny+ci;
					sz=-sz+nz+cj;
				}
			} else {
				
				if (r2modeB=="Normal") {
					sx=nx+(pixelr);
					sy=ny+(pixeli);
					sz=nz+(pixelj);
				} else if (r2modeB=="R2 mode 1") {
					sx=nx+sx+(pixelr);
					sy=ny+sy+(pixeli);
					sz=nz+sz+(pixelj);
				} else if (r2modeB=="R2 mode 2") {
					sx=-nx+sx+pixelr;
					sy=-ny+sy+pixeli;
					sz=-nz+sz+pixelj;
				} else if (r2modeB=="R2 mode 3") {
					sx=nx+sx*(pixelr)+pixelr;
					sy=ny+sy*(pixeli)+pixeli;
					sz=nz+sz*(pixelj)+pixelj;
				}
				
			}
			if (colormode=="Complex 1") {
				z=quaternion(real(bravo),imag(bravo),real(victor),imag(victor));
			} else if (colormode=="Type B") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,nx,ny,nz);
			} else if (colormode=="Normal") {
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Planar") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
					z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz);
			
		}
	 else if (fractaltype=="Mandelbrot 3d") {
				r2=(sqr(sx)+sqr(sy)+sqr(sz))^(n/2);
				
			/*if (sy>sz) {
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz))));	
			} else {
				theta=atan2((sx)-flip(sqrt(sqr(sy)+sqr(sz))));	
			}*/
			theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz))));
				phi=atan2((sy)+flip((sz)));
				
			if (switch_b) {
				if (switch_c) {
					if (theta==0) {
						tango=2*pi;
					} else {
						tango=theta;
					}
					foxtrot=atan2((sy)+flip(sqrt(sqr(sx)+sqr(sz))));
					gamma=atan2((sz)+flip(sqrt(sqr(sx)+sqr(sy))));		
					if (foxtrot==0) {
						foxtrot=2*pi;
					} 
					if (gamma==0) {
						gamma=2*pi;
					}
					theta=n*theta;
					phi=n*phi;
					nx=r2*cos(theta)*tango;
					ny=r2*abs(cos(phi))*sin (theta)*foxtrot;
					nz=r2*abs(sin(phi))*sin (theta)*gamma;
				} else {
					if (theta==0) {
						tango=0*pi;
					} else {
						tango=(theta+2*pi)/8;
					}
					if (switch_d) {
						foxtrot=atan2(flip(sx)+(sqrt(sqr(sy)+sqr(sz))));	
						foxtrot=sqrt(((foxtrot+2*pi)/8)^2+((phi+2*pi)/8)^2);											
					} else {
						foxtrot=tango;
					}
					theta=n*theta;
					phi=n*phi;
					nx=r2*cos(theta)*tango;
					ny=r2*abs(cos(phi))*sin (theta)*foxtrot;
					nz=-r2*abs(sin(phi))*sin (theta)*foxtrot;
				}	
			} else if (switch_c) {
				gamma=atan2(sqrt(sqr(sx)+sqr(sy))+flip(sz));
				if (theta==0) {
					whiskey=2*pi;
				} else {
					whiskey=theta;
				}	
				tango=sqrt(sqr(phi)+sqr(theta));
				if (tango==0) {
					tango=2*pi;
				}
				if (gamma==0) {
					foxtrot=2*pi;
				} else {
					foxtrot=gamma;
				}
				gamma=n*gamma;
				theta=n*theta;
				phi=n*phi;
				nx=r2*cos(theta)*whiskey;
				ny=r2*cos(phi)*sin (theta)*tango;
				nz=r2*sin(gamma)*foxtrot;
			} else {
				theta=n*theta;
				phi=n*phi;
				nx=r2*cos(theta);
				if (switch_d) {
					sw=sin(theta);
					su=cos(phi);
					sv=sin(phi);
					if (su<0) {
						ny=-r2*su*sw;
					} else {
						ny=r2*su*sw;
					} 
					if (sv<0) {
						nz=-r2*sv*sw;
					} else {
						nz=r2*sv*sw;
					}
				} else {
					ny=r2*cos(phi)*sin (theta);
					nz=r2*sin(phi)*sin (theta);
				}
			}
		
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				
			} else {
				sx=nx+(pixelr);
				sy=ny+(pixeli);
				sz=nz+(pixelj);
				
			}
			z=quaternion (sx,sy,sz,0);
			r=cabs(z);
			z=quaternion(r,sx,sy,sz);
			bail=abs(sx)+abs(sy)+abs(sz);
		}
	else if (fractaltype=="mag vs xyz") {
		
			if (radswitch) {
				r=(abs(abs(sx)*sx+sy*abs(sy)+sz*abs(sz)));
				r1=sqrt(sqr(sx)*a+r);
				r2=sqrt(sqr(sy)*a+r);
				r3=sqrt(sqr(sz)*a+r);
				r=sqrt(r);
			} else {
				r=(sqr(sx)+sqr(sy)+sqr(sz));
				r1=sqrt(sqr(sx)*a+r);
				r2=sqrt(sqr(sy)*a+r);
				r3=sqrt(sqr(sz)*a+r);
				r=sqrt(r);
			}
		
		if (switch_c) {
			r1b=sqrt(abs(abs(sx)*sx+abs(sy)*sy+abs(sz)*sz));
			r2b=r1b;
			r3b=r2b;
			
			theta=atan2(abs(sx)*checkvar+flip(r1b));
			phi=atan2(abs(sy)*checkvar+flip(r2b));
			tango=atan2(abs(sz)*checkvar+flip(r3b));
		}
		else if (switch_d) {
			r1b=sqrt(sqr(sx)+abs(abs(sy)*sy+abs(sz)*sz));
			r2b=sqrt(sqr(sy)+abs(abs(sx)*sx+abs(sz)*sz));
			r3b=sqrt(sqr(sz)+abs(abs(sx)*sx+abs(sy)*sy));
			
			theta=atan2(abs(sx)*checkvar+flip(r1b));
			phi=atan2(abs(sy)*checkvar+flip(r2b));
			tango=atan2(abs(sz)*checkvar+flip(r3b));	
		} else if (switch_a) {
			r1b= sqr(sx)+abs(sy)*sy+abs(sz)*sz;
			r2b= sqr(sy)+abs(sx)*sx+abs(sz)*sz;
			r3b= sqr(sz)+abs(sx)*sx+abs(sy)*sy;
			if (r1b<0) {
				r1b=-sqrt(abs(r1b)); 
			} else {
				r1b=sqrt(abs(r1b)); 
			}
			if (r2b<0) {
				r2b=-sqrt(abs(r2b)); 
			} else {
				r2b=sqrt(abs(r2b)); 
			}
			if (r3b<0) {
				r3b=-sqrt(abs(r3b)); 
			} else {
				r3b=sqrt(abs(r3b)); 
			}
			theta=atan2(abs(sx)*checkvar+flip(r1b));
			phi=atan2(abs(sy)*checkvar+flip(r2b));
			tango=atan2(abs(sz)*checkvar+flip(r3b));		
		} else if (switch_b) {
			r1b= sqrt(abs(sqr(sx)+abs(sy)*sy+abs(sz)*sz));
			r2b=sqrt(abs( sqr(sy)+abs(sx)*sx+abs(sz)*sz));
			r3b=sqrt(abs( sqr(sz)+abs(sx)*sx+abs(sy)*sy));
			
			theta=atan2(abs(sx)*checkvar+flip(r1b));
			phi=atan2(abs(sy)*checkvar+flip(r2b));
			tango=atan2(abs(sz)*checkvar+flip(r3b));		
		} else {
			theta=atan2(abs(sx)*checkvar+flip(r));
			phi=atan2(abs(sy)*checkvar+flip(r));
			tango=atan2(abs(sz)*checkvar+flip(r));
			r1b=r;
			r2b=r;
			r3b=r;
		}
			r1=r1^n;
			r2=r2^n;
			r3=r3^n;
		
		if (switch_c) {
			nx=r2*cos(theta*n);
			ny=r2*cos(phi*n);
			nz=r2*cos(tango*n);
		} else {
			nx=r1*cos(theta*n);
			ny=r2*cos(phi*n);
			nz=r3*cos(tango*n);
		}
			if (magswitch) {
				if (n==2 || n==6) {
						if (pixelr>0 && sx*checkvar>r1b) {
							nx=-nx;
						}
						if (pixeli>0 && sy*checkvar>r2b) {
							ny=-ny;
						}
						if (pixelj>0 && sz*checkvar>r3b) {
							nz=-nz;
						}
				} else {
					if (pixelr>0 && sx>0) {
						nx=-nx;
					}
					if (pixeli>0 && sy>0) {
						ny=-ny;
					}
					if (pixelj>0 && sz>0) {
						nz=-nz;
					}
				}
			}

			if (juliaMode) {
				if (r2modeB=="Normal") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
				} else if (r2modeB=="R2 mode 1") {
					sx=sx-nx+cr;
					sy=sy-nz+ci;
					sz=sz-ny+cj;
				} else if (r2modeB=="R2 mode 2") {
					sx=-sx+nx+cr;
					sy=-sy+nz+ci;
					sz=-sz+ny+cj;
				}
			} else {
				
				if (r2modeB=="Normal") {
					sx=nx+(pixelr);
					sy=ny+(pixeli);
					sz=nz+(pixelj);
				} else if (r2modeB=="R2 mode 1") {
					sx=nx+sx+(pixelr);
					sy=nz+sy+(pixeli);
					sz=ny+sz+(pixelj);
				} else if (r2modeB=="R2 mode 2") {
					sx=-nx+sx+pixelr;
					sy=-nz+sy+pixeli;
					sz=-ny+sz+pixelj;
				} else if (r2modeB=="R2 mode 3") {
					sx=(nx+pixelr)*(n-1);
					sy=(ny+(pixeli))*(n-1);
					sz=(nz+(pixelj))*(n-1);
				}
				
			}
			if (colormode=="Normal") {
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Type B") {
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
				z=quaternion(r,nx,ny,nz);
			} 
			
		bail=sqr(sx)+sqr(sy)+sqr(sz);
	
	} else if (fractaltype=="Type B1") {
		    if (switch_a) {
			r2=(sqr(sx)+sqr(sy)+sqr(sz))^(n/2);
			} else {
			r2=((sqr(sx)+sqr(sx2))+sqr(sy)+sqr(sz))^(n/2);
			}
			
			theta=atan2(sx+flip(sy));
			tango=atan2(sx2+flip(sz)); 
			
			 if (juliaMode) {
			  sx=r2*cos(theta*n)+cr;
			 sx2=r2*cos(tango*n)+cr;
			 sy=r2*sin(theta*n)+ci;
			 sz=r2*sin(tango*n)+cj;
			} else {
				sx=r2*cos(theta*n)+(pixelr);
				sx2=r2*cos(tango*n)+(pixelr);
			 sy=r2*sin(theta*n)+abs(pixeli);
			 sz=r2*sin(tango*n)+abs(pixelj);
			}
			z=quaternion (sx,sy,sz,0);
			r=cabs(z);
			z=quaternion(r,sx,sy,sz);
			
			bail=abs(sx)+abs(sy)+abs(sz);
	}  else if (fractaltype=="Type C2") {
			if (switch_a) {
				r2= (sqr(sx)+sqr(sy)+sqr(sz))^(n/2);
				
			} else {
				if (switch_b) {
				r1=(sqr(sx)+sqr(sy)+sqr(sz))^(n/2);
				r2=(sqr(sx2)+sqr(sy2)+sqr(sz2))^(n/2);
					} else {
				r2=(sqr(sx2)+sqr(sx)+sqr(sy2)+sqr(sy)+sqr(sz2)+sqr(sz))^(n/2);
				} 
			}
			
			if (switch_c) {
				theta=atan2(sx+flip(sy));
				tango=atan2(sx+flip(sz));
				whiskey=atan2(sy+flip(sz));
				foxtrot=atan2(sz+flip(sy));
				
				nx=r2*1*sqrt(cos(theta*n)^2+cos(tango*n)^2);
				ny=r2*1*sqrt(sin(theta*n)^2+cos(whiskey*n)^2);
				nz=r2*-1*sqrt(sin(tango*n)^2+sin(whiskey*n)^2);
				nx2=nx;
				ny2=ny;
				nz2=nz;
			} else {
				
					
				if (switch_b) {
						theta=atan2(sx+flip(sy));
						tango=atan2(sx2+flip(sz));
						whiskey=atan2(sy2+flip(sz2));
						nx=r2*cos(theta*n);
						nx2=r1*cos(tango*n);
						ny=r2*sin(theta*n);
						ny2=r1*cos(whiskey*n);
						nz=r2*sin(tango*n);
						nz2=r1*sin(whiskey*n);
				} else {	 
						theta=atan2(sx+flip(sy));
						tango=atan2(sx2+flip(sz));
						whiskey=atan2(sy2+flip(sz2));
						nx=r2*cos(theta*n);
						nx2=r2*cos(tango*n);
						ny=r2*sin(theta*n);
						ny2=r2*cos(whiskey*n);
						nz=r2*sin(tango*n);
						nz2=r2*sin(whiskey*n);
				}
			}
		  if (juliaMode) {
			sx=nx+cr;
			sx2=nx2+cr;
			sy=ny+ci;
			sy2=sy+ci;
			sz=sz+cj;
			sz2=sz2+cj;
		  } else {
			if (r2modeB=="Normal") {
				sx=nx+(pixelr);	
				sx2=nx2+pixelr;
				sy=ny+abs(pixeli);
				sy2=ny2+abs(pixeli);
				sz=nz+abs(pixelj);
				sz2=nz2+abs(pixelj);
			} else if (r2modeB=="R2 mode 1") {
				sx=nx+(pixelr);	
				sx2=nx2+sx;
				sy=ny+abs(pixeli);
				sy2=ny2+sy;
				sz=nz+abs(pixelj);
				sz2=nz2+sz;
			} else if (r2modeB=="R2 mode 2") {
				sx=nx+(pixelr);	
				sx2=nx2+sx;
				sy=ny+(pixeli);
				sy2=ny2+sy;
				sz=nz+(pixelj);
				sz2=nz2+sz;
			} else if (r2modeB=="R2 mode 3") {
				sx=sqrt(sqr(nx)+sqr(nx2))+(pixelr);	
				sx2=sx;
				sy=sqrt(sqr(ny)+sqr(ny2))+(pixeli);
				sy2=sy;
				sz=sqrt(sqr(nz)+sqr(nz2))+(pixelj);
				sz2=sz;
			}
		}
				bail=abs(sx)+abs(sy)+abs(sz);
			if (colormode=="Normal") {
			  z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Type B") {
				nx=sqrt(sqr(sx)+sqr(sx2));
				ny=sqrt(sqr(sy)+sqr(sy2));
				nz=sqrt(sqr(sz)+sqr(sz2));
				z=quaternion (nx,ny,nz,0);
				r=cabs(z);
				z=quaternion(r,nx,ny,nz);
			}
		} else if (fractaltype=="Type R2 D2") {
			
				r2= sqrt((sx^2+sy^2+sz^2)^n+(sw^2+sv^2+su^2)^n);

					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				
				 nx=r2*sin(n*phi) ;
				 ny=r2*sin(n*tango);
				 nz=r2*sin(n*theta);
				 nw=r2*cos(n*phi) ;
				 nv=r2*cos(n*tango) ;
				 nu=r2*cos(n*theta)  ;
				
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
			
			bail=abs(sx)+abs(sy)+abs(sz);
			z=quaternion (sx,sy,sz,0);
			r=cabs(z);
			z=quaternion(r,sx,sy,sz);
		}  else if (fractaltype=="R2 D2 intraplanar") {
					
					phi=atan2(sx+flip(sy));  /*su*/
					tango=atan2(sy+flip(sz));  /*sw*/
					theta=atan2(sx+flip(sz));     /*sv*/
					
				 sy2=sw*cos(n*tango);
				 sz2=sw*sin(n*tango);
				 sw=sqrt(sy2^2+sz2^2);
				 
				 sx2=su*cos(n*phi);
				 sy2=su*sin(n*phi);
				 su=sqrt(sx2^2+sy2^2);
				 
				 sx2=sv*cos(n*theta);
				 sz2=sv*sin(n*theta);
				 sv=sqrt(sx2^2+sz2^2);
				
				r2= sqrt((sx^2+sy^2+sz^2)^n+(sw^2+sv^2+su^2)^n);

					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
					
				 nx=r2*sin(n*phi) ;
				 ny=r2*sin(n*tango);
				 nz=r2*sin(n*theta);
				 
				 
				 nw=r2*cos(n*phi) ;
				 nv=r2*cos(n*tango) ;
				 nu=r2*cos(n*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
			
			bail=abs(sx)+abs(sy)+abs(sz);
			z=quaternion (sx,sy,sz,0);
			r=cabs(z);
			z=quaternion(r,sx,sy,sz);
		} else if (fractaltype=="Type D2") {
			if (switch_a) {
				r1=((sqr(sx)+sqr(sw))^(n/2)+(sqr(sy)+sqr(sv))^(n/2)+(sqr(sz)+sqr(su))^(n/2));
				r2=r1;
			} else {
				r1= ((sx^2+sy^2+sz^2+sw^2+sv^2+su^2))^(n/2);
				r2=r1;
			}
				 
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				
				 nx=r1*sin(n*phi) ;
				 ny=r1*sin(n*tango);
				 nz=r1*sin(n*theta);
				 nw=r2*cos(n*phi) ;
				 nv=r2*cos(n*tango) ;
				 nu=r2*cos(n*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
					sx=nx+pixelr;
					sy=ny+pixeli;
					sz=nz+pixelj;
					sw=nw+pixelw;
					sv=nv+pixelv;
					su=nu+pixelu;
				}
			
			bail=abs(sx)+abs(sy)+abs(sz);
			if (colormode=="Normal") {
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Planar") {
				z=quaternion(sw,sv,su,0);
				r=cabs(z);
				z=quaternion(r,sw,sv,su);
			} else if (colormode=="Plane Line") {
				nx=sqrt(sqr(sw)+sqr(sx));
				ny= sqrt(sqr(sv)+sqr(sy));
				nz= sqrt(sqr(su)+sqr(sz));
				z=quaternion(nx,ny,nz,0);
				r=cabs(z);
				z=quaternion(r,nx,ny,nz);
			} else if (colormode=="Type B") {
			     z=quaternion(nx,ny,nz,0);
				  r=cabs(z);
				z=quaternion(r,nx,ny,nz);
			} else if (colormode=="R line Plane") {
				 z=quaternion(sx,sy,sz,0);
				  r=cabs(z);
				z=quaternion(r,sw,sv,su);
			} else if (colormode=="R Plane line") {
				 z=quaternion(sw,sv,su,0);
				  r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
		}  else if (fractaltype=="Type D3") {
			
				r1=(sx^2+sw^2)^(n/2);
				r2=(sy^2+sv^2)^(n/2);
				r3=(sz^2+su^2)^(n/2);
			
			 
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				
			nx=r1*sin(n*phi) ;
			ny=r2*sin(n*tango);
			nz=r3*sin(n*theta);
			nw=r1*cos(n*phi) ;
			nv=r2*cos(n*tango) ;
			nu=r3*cos(n*theta)  ;
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
			}
			
			bail=abs(sx)+abs(sy)+abs(sz);
			z=quaternion (sx,sy,sz,0);
			r=cabs(z);
			z=quaternion(r,sx,sy,sz);
			
		} else if (fractaltype=="Type C1") {
	
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=r1;
		
		  theta=atan2(sx+flip(sy));
		  tango=atan2(sx2+flip(sz));
		  whiskey=atan2(sy2+flip(sz2));
		  
			if (juliaMode) {
			sx=r1*cos(theta*n)+cr;
			sx2=r2*cos(tango*n)+cr;
			sy=r1*sin(theta*n)+ci;
			sy2=r2*cos(whiskey*n)+ci;
			sz=r1*sin(tango*n)+cj;
			sz2=r2*sin(whiskey*n)+cj;
			} else {
				if (r2modeB=="Normal") {
					sx=r1*cos(theta*n)+pixelr;
					sx2=r2*cos(tango*n)+pixelr;
					sy=r1*sin(theta*n)+pixeli;
					sy2=r2*cos(whiskey*n)+pixeli;
					sz=r1*sin(tango*n)+pixelj;
					sz2=r2*sin(whiskey*n)+pixelj;
				} else if(r2modeB=="R2 mode 1") {
					sx=r1*cos(theta*n)+sx2+pixelr;
					sx2=r2*cos(tango*n)+sx+pixelr;
					sy=r1*sin(theta*n)+sy2+pixeli;
					sy2=r2*cos(whiskey*n)+sy+pixeli;
					sz=r1*sin(tango*n)+sz2+pixelj;
					sz2=r2*sin(whiskey*n)+sz+pixelj;
				} else if (r2modeB=="R2 mode 2") {
					sx=r1*cos(theta*n)+pixelr;
					sx2=r2*cos(tango*n)+pixelr;
					sy=r1*sin(theta*n)+pixeli;
					sy2=r2*cos(whiskey*n)+pixeli;
					sz=r1*sin(tango*n)+pixelj;
					sz2=r2*sin(whiskey*n)+pixelj;
				} else if (r2modeB=="R2 mode 3") {
					sx=r1*cos(theta*n)+pixelr;
					sx2=r2*cos(tango*n)+pixelr;
					sy=r1*sin(theta*n)+pixeli;
					sy2=r2*cos(whiskey*n)+pixeli;
					sz=r1*sin(tango*n)+pixelj;
					sz2=r2*sin(whiskey*n)+pixelj;
				}
			}
				bail=abs(sx)+abs(sy)+abs(sz);
			if (colormode=="Normal") {
			  z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			} else if (colormode=="Type B") {
				nx=sqrt(sqr(sx)+sqr(sx2));
				ny=sqrt(sqr(sy)+sqr(sy2));
				nz=sqrt(sqr(sz)+sqr(sz2));
				z=quaternion (nx,ny,nz,0);
				r=cabs(z);
				z=quaternion(r,nx,ny,nz);
			}
		} 
	}

	bool bailout(void)
	{
		return(bail<bailout);
	}
	
	void description(void)
	{
		this.title="3 D Benesi Set";
		
		bailout.caption = "Bailout Value";
		bailout.default =16;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.  Set high for these fractals as it smooths them out.";
		
		fractaltype.caption="Formula";
		fractaltype.enum="z-squared\nmag vs xyz\nBeautiful Fractal 1\nComplex Compound Double BS\nComplex Compound Mandel 3d\nBeautiful Fractal 2\nComplex Compound\nType D2\nType R2 D2\nType D3\nType B1\nType C1\nType C2\nR2 D2 intraplanar\nMandelbrot 3d";
		fractaltype.default=0;
		fractaltype.hint=" Some formulas, such as complex compound and Mandelbrot 3d are duplicates: 1 with trig functions, one with complex numbers.  The complex number versions run faster on my computer, but for optimized GPU implementations, you might want to use trig formulas.  If you need help, go to fractalforums.com";
		pixelmode.caption="Pixel Assignment";
		pixelmode.enum="+ no abs\nrotate pixel\nrotate pixel 2\n- no abs\n+y abs\n-y abs\n+z abs\n-z abs\n+y +z abs\n-y +z abs\n-y -z abs\n+y -z abs\n-x -y -z abs\n+x +y +z abs\nNew Mode 1\nExp 2\nNew Mode 1-\nExp 3\nExp 3b\nrotate pixel 3";	
		pixelmode.hint="Pick absolute values of y (+ or -) to add symmetry to even n z^n fractals";
		
		assignment.caption="P.V.A. Mode";
		assignment.enum="Magnitude\n-Magnitude\n-,+,+ Magnitude\n-,-,+ Magnitude\n-,+,- Magnitude\n+,-,+ Magnitude\n+,-,- Magnitude\n+,+,- Magnitude\nLinear Sign Magnitude\nPlanar Sign Magnitude\nComplexitude\n-Complexitude\nLinear Sign Complexitude\nPlanar Sign Complexitude";
		assignment.default=0;
		assignment.visible=(fractaltype=="Type D2" ||fractaltype=="Type R2 D2" || fractaltype=="Type D3" || fractaltype=="Type B1" || fractaltype=="Type C1" || fractaltype=="Type C2" || fractaltype=="R2 D2 intraplanar");
		assignment.hint="Planar variable assignment moded lets you specify how planar variables w, v, and u are assigned.  Leave on magnitude or -magnitude mode for most calculations, play around with complexitude modes for more complicated, albeit somewhat mismatched images";
		colormode.caption="Color Mode";
		colormode.hint="Does not influence all fractals.";
		colormode.visible=(fractaltype!="mag vs xyz" && fractaltype!="Type B1");
		colormode.enum="Normal\nType B\nPlanar\nComplex 1\nPlane Line\nR line Plane\nR Plane line";
		r2modeB.caption="R2 mode";
		r2modeB.hint="Switches how stuff is added in at end of calculation for some fractals, not implemented on all, check formulas to see";
		r2modeB.enum="Normal\nR2 mode 1\nR2 mode 2\nR2 mode 3\nR2 mode 4";
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		
		bmode.enum="Pi/2\nRoot 2\nGolden Ratio\nVariable";
		bmode.visible=(fractaltype=="mag vs xyz");
		bmode.hint="Change variable for calculation between golden ratio and square root of 2";
		checkvarset.caption="Multiplier";
		checkvarset.default=2;
		checkvarset.visible=(fractaltype=="mag vs xyz" && bmode=="Variable");
		checkvarset.hint="Set close to n for nice fractals, or for something interesting try -3, or other things";
		amode.caption="Calculation Mode";
		amode.visible=(fractaltype=="mag vs xyz");
		amode.visible=(fractaltype=="mag vs xyz");
		amode.hint="Change calculation mode for adding multiplier";
		amode.enum="b^(3-n)\nb*(n-1)^-1\nVariable";
		checkvarsetA.caption="Multiplier A";
		checkvarsetA.default=.1;
		checkvarsetA.visible=(fractaltype=="mag vs xyz" && amode=="Variable");
		checkvarsetA.hint="Set lower for higher n, higher for lower n.  ";
		
		magswitch.visible=(fractaltype=="mag vs xyz");
		magswitch.caption="Switch M";
		magswitch.hint="Especially good for z^2.  Use for n=2,3,5...  not for n=4,8,12...";
		
		n.caption="n";
		n.default=2;
		n.hint="z^n.  n is the angular multiplier (rotation) and magnitude applied to the fractal formula.";
		
		
		switch_a.caption="Switch A";
		switch_a.hint="Old sumode switch. Switch modes of various fractals.  Not all (switch) modes verified, some fractals don't have switches so this does nothing for those fractals.  Some switches don't work unless others checked.";
		switch_a.visible=(fractaltype=="mag vs xyz" || fractaltype=="z-squared" || fractaltype=="Beautiful Fractal 1" || fractaltype=="Complex Compound Mandel 3d" || fractaltype=="Complex Compound Double BS" || fractaltype=="Type B1" || fractaltype=="Type C2" || fractaltype=="Type D2");
		switch_b.caption="Switch B";
		switch_b.hint="Old r2mode switch. Switch modes of various fractals.  Not all (switch) modes verified, some fractals don't have switches so this does nothing for those fractals.  Some switches don't work unless others checked.";
		switch_b.visible=(fractaltype=="Complex Compound Mandel 3d" || fractaltype=="mag vs xyz" || fractaltype=="z-squared" || fractaltype=="Beautiful Fractal 1" || fractaltype=="Beautiful Fractal 2" || fractaltype=="Complex Compound Double BS" || fractaltype=="Mandelbrot 3d" || fractaltype=="Type C2");
		switch_c.caption="Switch C";
		switch_c.visible=(fractaltype=="z-squared" ||fractaltype=="mag vs xyz" || fractaltype=="Beautiful Fractal 1" || fractaltype=="Beautiful Fractal 2" || fractaltype=="Complex Compound Double BS" || fractaltype=="Mandelbrot 3d" || fractaltype=="Type C2");
		switch_c.hint="Old colormodeB switch. Switch modes of various fractals.  Not all (switch) modes verified, some fractals don't have switches so this does nothing for those fractals.  Some switches don't work unless others checked.";
		switch_d.caption="Switch D";
		switch_d.visible=(fractaltype=="z-squared" ||fractaltype=="mag vs xyz" || fractaltype=="Beautiful Fractal 1" || fractaltype=="Beautiful Fractal 2" || fractaltype=="Mandelbrot 3d");
		switch_d.hint="Old colormodeC switch. Switch modes of various fractals.  Not all (switch) modes verified, some fractals don't have switches so this does nothing for those fractals.  Some switches don't work unless others checked.";
		
		c.caption="Julia Seed";
		c.default=(0,0,0,0); /*(0.3,-0.44,-0.57,0.3); */
		c.hint="for Julia fractals set values 1,2 and 3 of this and c2";
		
		radswitch.visible=(fractaltype=="mag vs xyz");
		radswitch.caption="Radius Switch";
		radswitch.hint="Not too interesting.  Maybe mess with z^2.";
		
		absmodexn.caption="absmode x-";
		absmodexn.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodexn.hint="- abs is a good default setting for all fractals (including best n=2)(preserves continuity)";
		absmodexn.visible=(fractaltype=="Complex Compound");
		
		absmodexp.caption="absmode x+";
		absmodexp.visible=(fractaltype=="Complex Compound");
		absmodexp.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodexp.hint="+ no abs is good for all (including best n=2) except n=4,8,12,16...  - abs is a better default setting for n=4,8,12,16 and a good alternate for all others, for n=5,9,13... - r3abs abs is very nice!";
		absmodexp.default=6;
		
		absmodeyn.caption="absmode y-";
		absmodeyn.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodeyn.hint="- abs is a good default setting for all fractals (including best n=2)(preserves continuity)";
		absmodeyn.visible=(fractaltype=="Complex Compound");
		
		absmodeyp.caption="absmode y+";
		absmodeyp.visible=(fractaltype=="Complex Compound");
		absmodeyp.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodeyp.hint="+ no abs is good for all (including best n=2) except n=4,8,12,16...  - abs is a better default setting for n=4,8,12,16 and a good alternate for all others, for n=5,9,13... - r3abs abs is very nice!";
		absmodeyp.default=6;
		
		absmodezn.caption="absmode z-";
		absmodezn.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodezn.hint="+ r3abs abs is a good default setting for all fractals except n=????..., for n=??2,6,10?? you can use + abs, which is a good alternate for all others.  The best n=2 is -r3abs no abs or (maybe) +r3abs no abs (which is good for n=4 as well)!!!";
		absmodezn.default=2;
		absmodezn.visible=(fractaltype=="Complex Compound");
		
		absmodezp.caption="absmode z+";
		absmodezp.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodezp.default=3;
		absmodezp.hint="- r3abs abs is a good default for all except 2,6,10,14... use + abs for 2,6,10,14... also + abs is a good alternate for all others.  The best n=2 and maybe n=4? is -r3abs no abs!!!";
		absmodezp.visible=(fractaltype=="Complex Compound");
		
		zvalue.caption="Exp. Mode";
		zvalue.enum="None\nOne\nTwo\nThree";
		zvalue.visible=(fractaltype=="Complex Compound");
		}
}

cp_7079(QUATERNION) { 
/*  Copyright Matthew Benesi   All Rights Reserved  */
/*  These formulas are only authorized for distribution with ChaosPro */
/*  Derivative works may not be distributed without authors permission   */
/*  2/11/2010 */
parameter real bailout,mandalabailout;
parameter quaternion perturb;
parameter quaternion c,time;
parameter real c2;
real sx,sx2,sx3,sy,sy2,sy3,sz,sz2,sz3,sw,sv,su;
real sk,sl,sk2,sk3,sl2,st;
real nk,nl,nt,ns;
real nx,ny,nz,nw,nv,nu;
real nx2,nx3,ny2,ny3,nz2,nz3,nk2,nk3;
real r,r1,r2,r3,r4,r5,r1b,r2b,r3b,r4b,a,b,bail;
parameter int fractaltype;
parameter int assignment,timemode;
real cr,ci,cj,ck,cw,cv,cu,i,ct;
complex victor,bravo,cramden,ralph;  
real checkvar,theta,phi,tango,whiskey,foxtrot,gamma;
real pixelr,pixeli,pixelj,pixelk,pixelw,pixelv,pixelu,pixelt;
parameter real n,checkvarset;
parameter int r2modeb,bmode;
parameter bool juliaMode,r2mode,colormode,abspixelmode,typeB,amode,magswitch;

	void init(void)
	{
	  		if (fractaltype=="mag vs xyz") {
			if (bmode=="Pi/2") {
				b=pi/2;
			} else if (bmode=="Root 2") {
				b=sqrt(2);
			} else if (bmode=="Golden Ratio"){
				b=(1+sqrt(5))/2;
			} else if (bmode=="Variable"){
				b=checkvarset;
			}
			
				checkvar=(n)*b;
			
			//a=sqrt(8)*(n)^-1;
			if (! amode) {
				a=b^(3-n);
			} else {
				a=b*(n-1)^-1;
			}
			
			//a=sqrt(n)*(n-1)^-1;
		}
		
		
		if (fractaltype=="Mandala") {
		bailout=mandalabailout;
		}
		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		ck=part_k(c);
		
		if (abspixelmode) {
			pixelr=part_r(pixel);
			pixeli=abs(part_i(pixel));
			pixelj=abs(part_j(pixel));
		} else {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
		}
		if (timemode=="Normal") {
			if (abspixelmode) {
				pixelk=-abs(c2);
			} else {
				pixelk=c2;
			}
		} else if (timemode=="Total Mag") {
			pixelk=sqrt(pixelr^2+pixeli^2+pixelj^2);
		} else if (timemode=="-Total Mag") {
			pixelk=0-sqrt(pixelr^2+pixeli^2+pixelj^2);
		} else if (timemode=="Special 1") {
			pixelk=sqrt(pixelr^2+pixeli^2+pixelj^2);
			if ((pixelr+pixeli+pixelj)>pixelk) {
				pixelk=-pixelk;
			}
		} else if (timemode=="Special 2") {
			pixelk=sqrt(pixelr^2+pixeli^2+pixelj^2);
			if ((pixelr+pixeli+pixelj)>0) {
				pixelk=-pixelk;
			}
		} else if (timemode=="Special 3") {
			pixelk=(pixelr+pixeli+pixelj)/3;
		} else if (timemode=="Special 4") {
			pixelk=-(pixelr+pixeli+pixelj)/3;
		} else if (timemode=="Special 5") {
			pixelk=-pixelj;
		}  else if (timemode=="Exp 1") {
			pixelk=-(pixelr+pixeli+pixelj)/3;
			cw=pixelr-pixeli-pixelj;
			cv=pixeli-pixelr-pixelj;
			cu=pixelj-pixelr-pixeli;
			pixelr=cw;
			pixeli=cv;
			pixelj=cu;
			
		}   else if (timemode=="Exp 2") {
			pixelk=(pixelr+pixeli+pixelj)/3;
			cw=pixelr-pixeli-pixelj;
			cv=pixeli-pixelr-pixelj;
			cu=pixelj-pixelr-pixeli;
			pixelr=cw;
			pixeli=cv;
			pixelj=cu;
			
		}   else if (timemode=="Exp 3") {
			pixelk=(pixelr+pixeli+pixelj)/3;
			cw=pixelr^2-pixeli^2-pixelj^2;
			cv=pixeli^2-pixelr^2-pixelj^2;
			cu=pixelj^2-pixelr^2-pixeli^2;
			pixelr=sqrt(abs(cw));
			pixeli=sqrt(abs(cv));
			pixelj=sqrt(abs(cu));
			
		}   else if (timemode=="Exp 4") {
			pixelk=-(pixelr+pixeli+pixelj)/3;
			cw=pixelr^2-pixeli^2-pixelj^2;
			cv=pixeli^2-pixelr^2-pixelj^2;
			cu=pixelj^2-pixelr^2-pixeli^2;
			pixelr=sqrt(abs(cw));
			pixeli=sqrt(abs(cv));
			pixelj=sqrt(abs(cu));
			
		}
		
		/* Assigning different values to the planar variables can result in interesting
		   images, so I decided to include the ability to do so in this version of the code.
			Additional variety can be implemented by further varying the method of planar 
			assignment, although a large amount of the various possibilities of sign +/-
			assignment are "mixed and matched" in the various linear/planar sign assignment
			schemes */
		
	
		   /* altered signs of time values to offset pixel mass in first 2 */
		if (assignment=="Magnitude") {
			pixelw=sqrt(pixeli^2+pixelj^2+pixelk^2);
			pixelv=sqrt(pixelr^2+pixelj^2+pixelk^2);
			pixelu=sqrt(pixelr^2+pixeli^2+pixelk^2);
			pixelt=sqrt(pixelr^2+pixeli^2+pixelj^2);
			cw=sqrt(ci^2+cj^2+ck^2);
			cv=sqrt(cr^2+cj^2+ck^2);
			cu=sqrt(cr^2+ci^2+ck^2);
			ct=sqrt(cr^2+ci^2+cj^2);
		} else if (assignment=="-Magnitude") {
			pixelw=0-sqrt(pixeli^2+pixelj^2+pixelk^2);
			pixelv=0-sqrt(pixelr^2+pixelj^2+pixelk^2);
			pixelu=0-sqrt(pixelr^2+pixeli^2+pixelk^2);
			pixelt=0-sqrt(pixelr^2+pixeli^2+pixelj^2);
			
			cw=0-sqrt(ci^2+cj^2+ck^2);
			cv=0-sqrt(cr^2+cj^2+ck^2);
			cu=0-sqrt(cr^2+ci^2+ck^2);
			ct=0-sqrt(cr^2+ci^2+cj^2);
			
		}
		
		
		if (juliaMode) {
			sx=pixelr;
			sy=pixeli;
			sz=pixelj;
			sk=pixelk;
			
			sw=pixelw;
			sv=pixelv;
			su=pixelu;
			st=pixelt;
			
			
		} else {
			sx=cr;
			sy=ci;
			sz=cj;
			sk=ck;
			
			sw=cw;
			sv=cv;
			su=cu;
			st=ct;
			
		}
		if (fractaltype=="Type C2") {
		sx2=sx;
		sx3=sx;
		sy2=sy;
		sy3=sy;
		sz2=sz;
		sz3=sz;
		sk2=sk;
		sk3=sk;
		}	
		 
	}
	void loop(void)
	{
	 if (fractaltype=="Beautiful Fractal 4d C") {
		victor=complex(sx,sqrt(sqr(sy)+sqr(sz)+sqr(sk)));
		bravo=complex(sqrt(sqr(sx)+sqr(sy)+sqr(sk)),sz);
		cramden=complex(sqrt(sqr(sx)+sqr(sk)),sy);
		ralph=complex(sx,sk);
		
		r1=cabs(cramden)^-n;
		r2=cabs(ralph)^-n;
		victor=victor^n;
		bravo=bravo^n;
		cramden=cramden^n;
		ralph=ralph^n;
		
		nx=part_r(victor);
		ny=-abs(part_i(bravo));
		nz=-abs(part_r(bravo)*part_i(cramden))*r1;
		if (typeB) {
			nk=(part_r(bravo)*part_r(cramden)*part_i(ralph))*r1*r2;
		} else {
			nk=-abs(part_r(bravo)*part_r(cramden)*part_i(ralph))*r1*r2;
		}
		
			if (juliaMode) {
				if (r2modeb=="r2 mode 1") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
					sk=nk+sk+ck;
				} else if (r2modeb=="Normal") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
					sk=nk+ck;
				} else if (r2modeb=="r2 mode 2") {
					sx=nx+sx+cr;
					sy=ny+sy+ci;
					sz=nz+sz+cj;
					sk=nk+sk+ck;
				} else if (r2modeb=="r2 mode 3") {
					sx=nx+sx+cr;
					sy=ny+sz+ci;
					sz=nz+sy+cj;
					sk=nk+sk+ck;
				} 
			} else {
			   if (r2modeb=="r2 mode 1") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+sk+(pixelk);
					
				} else if (r2modeb=="r2 mode 2") {
						sx=nx-sx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+sk+(pixelk);
					
				} else if (r2modeb=="r2 mode 3") {
						sx=nk+(pixelk);
						sy=ny+(pixelr);
						sz=nz+(pixeli);
						sk=nx+(pixelj);
					
				} else if (r2modeb=="r2 mode 4") {
						sx=nk+(pixelk);
						sy=ny+(pixelr);
						sz=nz+(pixeli);
						sk=nx+sk+(pixelj);
					
				} else if (r2modeb=="Normal") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+(pixelk);
				}
			}
			if (colormode) {
				z=quaternion(sx,sy,sz,sk);
			} else {
				z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			
	}
	else if (fractaltype=="Beautiful Fractal 4d B") {
		victor=complex(sx,sqrt(sqr(sy)+sqr(sz)+sqr(sk)));
		bravo=complex(sqrt(sqr(sx)+sqr(sy)+sqr(sk)),sz);
		cramden=complex(sqrt(sqr(sx)+sqr(sk)),sy);
		ralph=complex(sx,sk);
		
		r1=cabs(cramden)^-n;
		r2=cabs(ralph)^-n;
		victor=victor^n;
		bravo=bravo^n;
		cramden=cramden^n;
		ralph=ralph^n;
		
		nx=part_r(victor);
		ny=-abs(part_i(bravo));
		nz=-abs(part_r(bravo)*part_i(cramden))*r1;
		if (typeB) {
			nk=(part_r(bravo)*part_r(cramden)*part_i(ralph))*r1*r2;
		} else {
			nk=-abs(part_r(bravo)*part_r(cramden)*part_i(ralph))*r1*r2;
		}
		
			if (juliaMode) {
				if (r2modeb=="r2 mode 1") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
					sk=nk+sk+ck;
				} else if (r2modeb=="Normal") {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
					sk=nk+ck;
				} else if (r2modeb=="r2 mode 2") {
					sx=nx+sx+cr;
					sy=ny+sy+ci;
					sz=nz+sz+cj;
					sk=nk+sk+ck;
				} else if (r2modeb=="r2 mode 3") {
					sx=nx+sx+cr;
					sy=ny+sz+ci;
					sz=nz+sy+cj;
					sk=nk+sk+ck;
				} 
			} else {
			   if (r2modeb=="r2 mode 1") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+sk+(pixelk);
					
				} else if (r2modeb=="r2 mode 2") {
						sx=nx-sx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+sk+(pixelk);
					
				} else if (r2modeb=="r2 mode 3") {
						sx=nx+sk+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+sx+(pixelk);
					
				} else if (r2modeb=="Normal") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+(pixelk);
				}
			}
			if (colormode) {
				z=quaternion(sx,sy,sz,sk);
			} else {
				z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			
	} else  
	if (fractaltype=="Beautiful Fractal 4d A") {
		victor=complex(sx,sqrt(sqr(sy)+sqr(sz)+sqr(sk)));
		bravo=complex(sqrt(sqr(sx)+sqr(sy)+sqr(sz)),sk);
		cramden=complex(sqrt(sqr(sx)+sqr(sy)),sz);
		ralph=complex(sx,sy);
		
		r1=cabs(cramden)^-n;
		r2=cabs(ralph)^-n;
		victor=victor^n;
		bravo=bravo^n;
		cramden=cramden^n;
		ralph=ralph^n;
		
		nx=part_r(victor);
		if (typeB) {
			ny=-abs(part_i(bravo));
			nk=-abs(part_r(bravo)*part_i(cramden))*r1;
			nz=-abs(part_r(bravo)*part_r(cramden)*part_i(ralph))*r1*r2;
		} else {
			ny=-abs(part_i(bravo));
			nk=abs(part_r(bravo)*part_i(cramden))*r1;
			nz=-abs(part_r(bravo)*part_r(cramden)*part_i(ralph))*r1*r2;
		}	

		
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sk=nk+ck;
			} else {
			   if (r2mode) {
						sx=nx-sx+pixelk;
						sy=ny+(pixelr);
						sz=nz+(pixeli);
						sk=nk+(pixelj);
					
				} else {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+(pixelk);
				}
			}
			if (colormode) {
				z=quaternion(real(victor),real(bravo),real(cramden),imag(cramden));
			} else {
				z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			
	} else  if (fractaltype=="Complex Compound 4d") {
			r1=sqrt(sqr(sy)+sqr(sz)+sqr(sk));
			r2=sqrt(sqr(sz)+sqr(sk));
			
			if (n<11) {
				r3=r1^n;
			} else if (n==11) {
				r3=sqr(sqr(sqr(r1)))*sqr(r1)*r1;
			} else if (n==13) {
				r3=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*r1;
			} else if (n==15) {
				r3=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*sqr(r1)*r1;
			} else if (n==16) {
				r3=sqr(sqr(sqr(sqr(r1))));
			} else if (n==17) {
				r3=sqr(sqr(sqr(sqr(r1))))*r1;
			}  else {
				r3=r1^n;
			} 
			r3=r3^(-1);
			if (n<11) {
				r4=r2^n;
			} else if (n==11) {
				r4=sqr(sqr(sqr(r2)))*sqr(r2)*r2;
			} else if (n==13) {
				r4=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*r2;
			} else if (n==15) {
				r4=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==16) {
				r4=sqr(sqr(sqr(sqr(r2))));
			} else if (n==17) {
				r4=sqr(sqr(sqr(sqr(r2))))*r2;
			}  else {
				r4=r2^n;
			} 
			r4=r4^-1;
			
			victor=complex(sx,r1);
			bravo=complex(sy,r2);
			cramden=complex(sz,sk);	
			if (n<11) {
				victor=victor^n;
			} else if (n==11) {
				victor=sqr(sqr(sqr(victor)))*sqr(victor)*victor;
			} else if (n==13) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*victor;
			} else if (n==15) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*sqr(victor)*victor;
			} else if (n==16) {
				victor=sqr(sqr(sqr(sqr(victor))));
			} else if (n==17) {
				victor=sqr(sqr(sqr(sqr(victor))))*victor;
			}  else {
				victor=victor^n;
			} 
			if (n<11) {
				bravo=bravo^n;
			} else	if (n==11) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(bravo)*bravo;
			} else if (n==13) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*bravo;
			} else if (n==15) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*sqr(bravo)*bravo;
			} else if (n==16) {
				bravo=sqr(sqr(sqr(sqr(bravo))));
			} else if (n==17) {
				bravo=sqr(sqr(sqr(sqr(bravo))))*bravo;
			}  else {
				bravo=bravo^n;
			} 
			if (n<11) {
				cramden=cramden^n;
			} else if (n==11) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(cramden)*cramden;
			} else if (n==13) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*cramden;
			} else if (n==15) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*sqr(cramden)*cramden;
			} else if (n==16) {
				cramden=sqr(sqr(sqr(sqr(cramden))));
			} else if (n==17) {
				cramden=sqr(sqr(sqr(sqr(cramden))))*cramden;
			}  else {
				cramden=cramden^n;
			} 
			if (r2mode) {
				nx=part_r(victor);
				r3=part_i(victor)*r3;
				ny=r3*part_r(bravo);
				r3=part_i(bravo)*r3*r4;
				nz=r3*part_r(cramden);
				nk=r3*part_i(cramden);
			} else {
				nx=part_r(victor);
				if (n==2 || n==6) {
					if (sx>(r1) && pixelr>0) {
						nx=-nx;
					}
				}
				r3=-abs(part_i(victor))*r3;
				ny=part_r(bravo)*r3;
				
				r3=-abs(part_i(bravo)*r3*r4);
				nz=r3*part_r(cramden);
				nk=r3*part_i(cramden);		
			}
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sk=nk+ck;
			} else {
			   if (r2modeb=="Normal") {
						sx=nx+pixelr;
						sy=ny+pixeli;
						sz=nz+pixelj;
						sk=nk+pixelk;
					} else if (r2modeb=="r2 mode 1") {
						sx=nx-sx+pixelk;
						sy=ny+pixelr;
						sz=nz+pixeli;
						sk=nk+pixelj;
					} else if (r2modeb=="r2 mode 2") {
						sx=nx+sx+pixelk;
						sy=ny+pixelr;
						sz=nz+pixeli;
						sk=nk+pixelj;
					} else if (r2modeb=="r2 mode 3") {
						sx=nx+pixelr;
						sy=ny+pixeli;
						sz=nz+pixelj;
						sk=nk-sx+pixelk;
					} else if (r2modeb=="r2 mode 4") {
						sx=nx+sx+pixelk;
						sy=ny+pixelr;
						sz=nz+pixeli;
						sk=nk+pixelj;
					}
			}
			if (colormode) {
				z=quaternion(sx,sy,sz,sk);
			} else {
				z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			
		}
		else if (fractaltype=="Mandelbrot 4d") {
			r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
			
			if (r2mode) {
				theta=n*atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz)+sqr(sk))));		
				phi=n*atan2((sy)+flip(sqrt(sqr(sz)+sqr(sk))));
				tango=n* atan2((sz)+flip((sk)));
			} else {
				theta=n*atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz)+sqr(sk))));		
				phi=n*atan2((sy)+flip(sqrt(sqr(sz)+sqr(sk))));
				tango=n* atan2((sz)+flip((sk)));
			}
			nx=r2*cos(theta);
			theta=sin(theta);
			ny=r2*theta*cos(phi);
			phi=sin(phi);
			nz=r2*theta*phi*cos(tango);
			nk=r2*theta*phi*sin(tango);
				
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sz=nk+ck;
			} else {
				sx=nx+(pixelr);
				sy=ny+(pixeli);
				sz=nz+(pixelj);
				sk=nk+(pixelk);
			}
			z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
		}
	 else if (fractaltype=="Type C2") {
			if (r2mode) {
				r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
			} else {
				r2=(sqr(sx3)+sqr(sx2)+sqr(sx)+sqr(sy3)+sqr(sy2)+sqr(sy)+sqr(sz3)+sqr(sz2)+sqr(sz)+sqr(sk3)+sqr(sk2)+sqr(sk))^(n/2);
			}
		  
		  theta=atan2(sx+flip(sy));
		  tango=atan2(sx2+flip(sz));
		  whiskey=atan2(sx3+flip(sk));
		 phi= atan2(sy2+flip(sz2));
		 foxtrot= atan2(sy3+flip(sk2));
		gamma=  atan2 (sz3+flip(sk3));
		
		nx=r2*cos(theta*n);
		  nx2=r2*cos(tango*n);
		  nx3=r2*cos(whiskey*n);
		  ny=r2*sin(theta*n);
		  ny2=r2*cos(phi*n);
		  ny3=r2*cos(foxtrot*n);
		  nz=r2*sin(tango*n);
		  nz2=r2*sin(phi*n);
		  nz3=r2*cos(gamma*n);
		  nk=r2*sin(whiskey*n);
		  nk2=r2*sin(foxtrot*n);
		  nk3=r2*sin(gamma*n);
		
		  if (juliaMode) {
		  sx=nx +cr;
		  sx2=nx2+cr;
		  sx3=nx3+cr;
		  sy=ny+ci;
		  sy2=ny2+ci;
		  sy3=ny3+ci;
		  sz=nz+cj;
		  sz2=nz2+cj;
		  sz3=nz3+cj;
		  sk=nk+ck;
		  sk2=nk2+ck;
		  sk3=nk3+ck;
		  } else {
		 
		    sx=nx +pixelr;
		  sx2=nx2+pixelr;
		  sx3=nx3+pixelr;
		  sy=ny+pixeli;
		  sy2=ny2+pixeli;
		  sy3=ny3+pixeli;
		  sz=nz+pixelj;
		  sz2=nz2+pixelj;
		  sz3=nz3+pixelj;
		  sk=nk+pixelk;
		  sk2=nk2+pixelk;
		  sk3=nk3+pixelk;
		}
				bail=abs(sx)+abs(sy)+abs(sz);

			  z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
		} else if (fractaltype=="mag vs xyz") {
			
				r=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk));
			
				r1=(sqr(sx)*a+r)^(n/2);
				r2=(sqr(sy)*a+r)^(n/2);
				r3=(sqr(sz)*a+r)^(n/2);
				r4=(sqr(sk)*a+r)^(n/2);
		r=sqrt(r);
			
		if (r2mode) {
			r1b= sqrt(abs(sqr(sx)+abs(sy)*sy+abs(sz)*sz+abs(sk)*sk));
			r2b=sqrt(abs( sqr(sy)+abs(sx)*sx+abs(sz)*sz+abs(sk)*sk));
			r3b=sqrt(abs( sqr(sz)+abs(sx)*sx+abs(sy)*sy+abs(sk)*sk));
			r4b=sqrt(abs( sqr(sk)+abs(sx)*sx+abs(sy)*sy+abs(sz)*sz));
			theta=atan2(abs(sx)*checkvar+flip(r1b));
			phi=atan2(abs(sy)*checkvar+flip(r2b));
			tango=atan2(abs(sz)*checkvar+flip(r3b));	
			whiskey=atan2(abs(sk)*checkvar+flip(r4b));
			} else {
			theta=atan2(abs(sx)*checkvar+flip(r));
			phi=atan2(abs(sy)*checkvar+flip(r));
			tango=atan2(abs(sz)*checkvar+flip(r));
			whiskey=atan2(abs(sk)*checkvar+flip(r));
			r1b=r;
			r2b=r;
			r3b=r;
			r4b=r;
			}
		nx=r1*cos(theta*n);
		ny=r2*cos(phi*n);
		nz=r3*cos(tango*n);
		nk=r4*cos(whiskey*n);
		if (typeB) {
				if (n==2) {
						if (pixelr>0 && sx*checkvar>r1b) {
							nx=-nx;
						}
						if (pixeli>0 && sy*checkvar>r2b) {
							ny=-ny;
						}
						if (pixelj>0 && sz*checkvar>r3b) {
							nz=-nz;
						}
						if (pixelk>0 && sk*checkvar>r4b) {
							nk=-nk;
						}
				} else {
					if (pixelr>0 && sx>0) {
						nx=-nx;
					}
					if (pixeli>0 && sy>0) {
						ny=-ny;
					}
					if (pixelj>0 && sz>0) {
						nz=-nz;
					}
					if (pixelk>0 && sk>0) {
						nk=-nk;
					}
				}
			}
		
		if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sk=nk+ck;
				} else {
					if (r2modeb=="Normal") {
						sx=nx+pixelr;
						sy=ny+pixeli;
						sz=nz+pixelj;
						sk=nk+pixelk;
					} else if (r2modeb=="r2 mode 1") {
						sx=nx-sx+pixelk;
						sy=ny+pixelr;
						sz=nz+pixeli;
						sk=nk+pixelj;
					} else if (r2modeb=="r2 mode 2") {
						sx=nx+sx+pixelk;
						sy=ny+pixelr;
						sz=nz+pixeli;
						sk=nk+pixelj;
					} else if (r2modeb=="r2 mode 3") {
						sx=nx+pixelr;
						sy=ny+pixeli;
						sz=nz+pixelj;
						sk=nk-sx+pixelk;
					} else if (r2modeb=="r2 mode 4") {
						sx=nx+sk;
						sy=ny+pixelr;
						sz=nz+pixeli;
						sk=nk+pixelj;
					}
				}
	
		z=quaternion(sk,sx,sy,sz);
		bail=sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk);
	
	}
	 else if (fractaltype=="Type R2 D2") {
				
				r2= sqrt((sx^2+sy^2+sz^2+sk^2)^n+(sw^2+sv^2+su^2+st^2)^n);
				
				 
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
					whiskey=atan2(st+flip(sk));
					
				 nx=r2*sin(n*phi) ;
				 ny=r2*sin(n*tango);
				 nz=r2*sin(n*theta);
				 nk=r2*sin(n*whiskey);
				
				 nw=r2*cos(n*phi) ;
				 nv=r2*cos(n*tango) ;
				 nu=r2*cos(n*theta)  ;
				 nt=r2*cos(n*whiskey);
				
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sk=nk+ck;
				
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				st=nt+ct;
				
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sk=nk+pixelk;
				
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				st=nt+pixelt;
				
				}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
		} else	if (fractaltype=="Type D2") {
		
				r1= ((sx^2+sy^2+sz^2+sk^2+sw^2+sv^2+su^2+st^2))^(n/2);
				r2=r1;
			
				 
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
					whiskey=atan2(st+flip(sk));
				
				 nx=r1*sin(n*phi) ;
				 ny=r1*sin(n*tango);
				 nz=r1*sin(n*theta);
				 nk=r1*sin(n*whiskey);
				
				 nw=r2*cos(n*phi) ;
				 nv=r2*cos(n*tango) ;
				 nu=r2*cos(n*theta)  ;
				 nt=r2*cos(n*whiskey);
				
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sk=nk+ck;
				
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				st=nt+ct;
				
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sk=nk+pixelk;
				
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				st=nt+pixelt;
				
				}
			
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			
			z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
		} else if (fractaltype=="Type D3") {
				r1=(sx^2+sw^2)^(n/2);
				r2=(sy^2+sv^2)^(n/2);
				r3=(sz^2+su^2)^(n/2);
				r4=(sk^2+st^2)^(n/2);
				
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
					whiskey=atan2(st+flip(sk));
				
				 nx=r1*sin(n*phi) ;
				 ny=r2*sin(n*tango);
				 nz=r3*sin(n*theta);
				 nk=r4*sin(n*whiskey);
				
				 nw=r1*cos(n*phi) ;
				 nv=r2*cos(n*tango) ;
				 nu=r3*cos(n*theta)  ;
				 nt=r4*cos(n*whiskey);
				
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sk=nk+ck;
				
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				st=nt+ct;
				
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sk=nk+pixelk;
				
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				st=nt+pixelt;
				
				}
		
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
		} else if (fractaltype=="Mandala") {
			
				r1=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
				r2=r1;
				
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
					whiskey=atan2(st+flip(sk));
				
				 nx=r1*sin(n*phi) ;
				 ny=r1*sin(n*tango);
				 nz=r1*sin(n*theta);
				 nk=r1*sin(n*whiskey);
				
				 nw=r2*cos(n*phi) ;
				 nv=r2*cos(n*tango) ;
				 nu=r2*cos(n*theta)  ;
				 nt=r2*cos(n*whiskey);
				
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sk=nk+ck;
				
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				st=nt+ct;
				
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sk=nk+pixelk;
				
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				st=nt+pixelt;
				
				}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
		}
	}

	bool bailout(void)
	{
		return(bail<bailout);
	}
	
	void description(void)
	{
		this.title="4 D Benesi Set";
		bailout.caption = "Bailout Value";
		bailout.default = 16;
		bailout.min = 0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.  Set high for these fractals as it smooths them out.";
		
		fractaltype.caption="Formula";
		fractaltype.enum="Complex Compound 4d\nBeautiful Fractal 4d A\nMandelbrot 4d\nType C2\nmag vs xyz\nType D2\nType R2 D2\nType D3\nMandala\nBeautiful Fractal 4d C\nBeautiful Fractal 4d B";
		fractaltype.default=0;
		fractaltype.hint="If you select Mandala, MAKE SURE TO ROTATE THE FRACTAL EITHER HORIZONTALLY OR VERTICALLY BY 45 DEGREES";
			
		assignment.caption="P.V.A. Mode";
		assignment.enum="Magnitude\n-Magnitude\nLinear Sign Magnitude\nPlanar Sign Magnitude\nComplexitude\n-Complexitude\nLinear Sign Complexitude\nPlanar Sign Complexitude";
		assignment.default=0;
		assignment.hint="Planar variable assignment moded lets you specify how planar variables w, v, and u are assigned.  Leave on magnitude or -magnitude mode for most calculations, play around with complexitude modes for more complicated, albeit somewhat mismatched images";
		
		timemode.caption="Time Mode";
		timemode.enum="Normal\nTotal Mag\n-Total Mag\nSpecial 1\nSpecial 2\nSpecial 3\nSpecial 4\nSpecial 5\nExp 1\nExp 2\nExp 3\nExp 4";
		timemode.default=0;
		
		r2modeb.caption="r2mode:";
		r2modeb.enum="Normal\nr2 mode 1\nr2 mode 2\nr2 mode 3\nr2 mode 4";
		
		bmode.enum="Pi/2\nRoot 2\nGolden Ratio\nVariable";
		bmode.visible=(fractaltype=="mag vs xyz");
		bmode.hint="Change variable for calculation between golden ratio and square root of 2";
		checkvarset.caption="Multiplier";
		checkvarset.default=2;
		checkvarset.visible=(fractaltype=="mag vs xyz" && bmode=="Variable");
		checkvarset.hint="Set close to n for nice fractals, or for something interesting try -3, or other things";
		
		magswitch.visible=(fractaltype=="mag vs xyz");
		magswitch.caption="Switch M";
		magswitch.hint="Especially good for z^2.  Use for n=2,3,5...  not for n=4,8,12...";
		
		
	
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		
		n.caption="n";
		n.default=2;
		n.hint="z^n.  n is the angular multiplier (rotation) and magnitude applied to the fractal formula.";
		
		
		amode.visible=(fractaltype=="mag vs xyz");
		amode.hint="Change calculation mode for adding multiplier";
		amode.caption="Calculation Mode";
		amode.visible=(fractaltype=="mag vs xyz");
		c.caption="c";
		c.default=(0,0,0,0); /*(0.3,-0.44,-0.57,0.3); */
		c.hint="for Julia fractals set values 1,2 and 3 of this and c2";
		c2.caption="c2";
		c2.default=0;
		c2.hint="change part_k c to c2 for older fractals";
	
		mandalabailout.caption="Mandala Bailout Value";
		mandalabailout.default=4;
		mandalabailout.hint="Set this higher AFTER you rotate your Mandala if you want a smoother Mandala";
		
		time.caption="Time component";
		time.default=quaternion(0,0,0,0);
		time.hint="Higher Dimensional components of fractals";
		
		}
}

cp_43782(QUATERNION) { 
/*  Copyright Matthew Benesi   All Rights Reserved  */
/*  These formulas are only authorized for distribution with ChaosPro */
/*  Derivative works may not be distributed without authors permission   */
/*  2/11/2010 */
parameter real bailout,mandalabailout;
parameter quaternion perturb;
parameter quaternion c,time;
parameter real c2;
real sx,sx2,sy,sy2,sz,sz2;
real sk,sk2,t1,t2;
real nx,nx2,ny,ny2,nz,nz2,nk;
real r,r1,r2,r3,r4,r5,r6,r1b,r2b,r3b,r4b,r5b,a,b,bail;
parameter int fractaltype;
parameter int assignment,timemode;
real cr,ci,cj,ck;
int i;
complex victor,bravo,cramden;
real checkvar,theta,phi,tango,whiskey,foxtrot,gamma;
real pixelr,pixeli,pixelj,pixelk,v,mag;
parameter real n,bail1,bail2,lt,pt,scalef,minRadius,fold,fixedRadius,check;
parameter bool bailcontrol,juliaMode,stringymode,mistake,sumode,r2mode,rXmodeb,rXmodec,absmode;

	void init(void)
	{    //for type G set r2mode and rXmodeB at same time
		
				b=pi/2;
				a=b^(3-n);
				b=(n)*b;
		  checkvar=b;	
		v=n;
		mag=n;
		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		ck=part_k(c);
		
		
		pixelr=part_r(pixel);
		pixeli=part_i(pixel);
		pixelj=part_j(pixel);
		if (timemode=="Total Mag") {
		pixelk=sqrt(pixelr^2+pixeli^2+pixelj^2);
		} else if (timemode=="-Total Mag") {
		pixelk=0-sqrt(pixelr^2+pixeli^2+pixelj^2);
		} else if (timemode=="Normal") {
		pixelk=c2;
		}
		
		
		
		if (juliaMode) {
			sx=pixelr;
			sx2=sx;
			sy=pixeli;
			sz=pixelj;
			sk=pixelk;
			sy2=sy;
			sz2=sz;
			
		} else {
			if (fractaltype=="Amazing Mag XYZ") {
				sx=pixelr;
				sy=pixeli;
				sz=pixelj;
			} else {
				sx=cr;
				sx2=sx;
				sy=ci;
				sz=cj;
				sk=ck;
				sy2=sy;
				sz2=sz;
			}
		}
		 
	}
	void loop(void)
	{
		if (fractaltype=="Amazing Mag XYZ") {
		  
			
			//rotation around y axis, no y rotation
			//whiskey=54.7356/180*pi;
			//foxtrot=(90-54.7356)/180*pi;
			whiskey= sqrt(2/3); //cos((foxtrot));
			tango= sqrt(1/3); //sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			sz= sx  * tango     +  sz * whiskey;
			sx=nx;
			
				//rotation around z axis, no z rotation
			//foxtrot=45/180*pi;
			whiskey=sqrt(.5);// cos((foxtrot));
			tango= whiskey; //sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			sy=sx*tango+sy*whiskey;
			sx=nx;
			
			r1= sqrt(sqr(sy)+sqr(sz));  // sx set
			r2=  sqrt(sqr(sx)+sqr(sz)); // sy
			r3=  sqrt(sqr(sx)+sqr(sy)); // sz
			r=(sqr(sx)+sqr(sy)+sqr(sz))^(n/2);
			b=n+1;
			theta=	n * atan2	(abs(sx)*b+flip(r1));
			phi=		n * atan2	(abs(sy)*b+flip(r2));
			tango=	n * atan2	(abs(sz)*b+flip(r3));
			
			sx=  (sqr(sx)+r)* cos(theta) -.5;
			sy=	(sqr(sy)+r) * cos(phi) -.5;
			sz=	(sqr(sz)+r)* cos(tango)-.5;
			
				//rotation around z axis, no z rotation
			//foxtrot=-45/180*pi;
			whiskey= sqrt(.5); //cos((foxtrot));
			tango= -whiskey;  //sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			sy=sx*tango+sy*whiskey;
			sx=nx;
			
			//rotation around y axis, no y rotation
			//foxtrot=-(90-54.7356)/180*pi;
			whiskey= sqrt(2/3);   //cos((foxtrot));
			tango= -sqrt(1/3);   //sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			sz= sx  * tango     +  sz * whiskey;
			sx=nx;
			
			 if (sx > check) {
                sx = fold - sx;
			} else if (sx<(0-check)) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<(0-check)) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<(0-check)) {
                sz = 0-fold - sz;
			}
             /*fold sphere onto itself   */
              r = (sqr(sx)+sqr(sy)+sqr(sz));
              if (r < sqr(minRadius)) {
                t1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*t1;
			 sy=sy*t1;
			 sz=sz*t1;
			} else if (r < sqr(fixedRadius)) {
                t2=(sqr(fixedRadius)/(r));
                sx=sx*t2;
			 sy=sy*t2;
			 sz=sz*t2;
			}
			
			 if (juliaMode) {
			  sx=sx*scalef+cr;
			 sy=sy*scalef+ci;
			 sz=sz*scalef+cj;
			} else {
			
			 sx=sx*scalef+(pixelr);
			 sy=sy*scalef+(pixeli);
			 sz=sz*scalef+(pixelj);
			}
			z=quaternion(sx,sy,sz,0);
			r=cabs(z);
			z=quaternion(r,sx,sy,sz);
			bail=sqr(sx)+sqr(sy)+sqr(sz);
		}
		else if (fractaltype=="BF Hybrid") {
		   if (sx > check) {
                sx = fold - sx;
			} else if (sx<(0-check)) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<(0-check)) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<(0-check)) {
                sz = 0-fold - sz;
			}
             /*fold sphere onto itself   */
              r = (sqr(sx)+sqr(sy)+sqr(sz));
              if (r < sqr(minRadius)) {
                t1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*t1;
			 sy=sy*t1;
			 sz=sz*t1;
			} else if (r < sqr(fixedRadius)) {
                t2=(sqr(fixedRadius)/(r));
                sx=sx*t2;
			 sy=sy*t2;
			 sz=sz*t2;
			}
			
		victor=complex(sx,sqrt(sqr(sy)+sqr(sz)));
		bravo=complex(sqrt(sqr(sx)+sqr(sy)),sz);
		cramden=complex(sx,sy);
		
		r1=cabs(cramden)^-n;
		victor=victor^n;
		bravo=bravo^n;
		cramden=cramden^n;
		
			nx=part_r(victor);
			ny=-abs(part_i(bravo));
			nz=-abs(part_r(bravo)*part_i(cramden))*r1;
			 if (juliaMode) {
			  sx=nx*scalef+cr;
			 sy=ny*scalef+ci;
			 sz=nz*scalef+cj;
			} else {
			
			 sx=nx*scalef+(pixelr);
			 sy=ny*scalef+abs(pixeli);
			 sz=nz*scalef+abs(pixelj);
			}
			z=quaternion(sx,sy,sz,0);
			r=cabs(z);
			z=quaternion(r,sx,sy,sz);
			bail=abs(sx)+abs(sy)+abs(sz);
		
	}
	
	else if (fractaltype=="Amazing Hybrid Correct Bulb") {
					   if (sx > check) {
                sx = fold - sx;
			} else if (sx<(0-check)) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<(0-check)) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<(0-check)) {
                sz = 0-fold - sz;
			}
             /*fold sphere onto itself   */
              r = (sqr(sx)+sqr(sy)+sqr(sz));
              if (r < sqr(minRadius)) {
                t1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*t1;
			 sy=sy*t1;
			 sz=sz*t1;
			} else if (r < sqr(fixedRadius)) {
                t2=(sqr(fixedRadius)/(r));
                sx=sx*t2;
			 sy=sy*t2;
			 sz=sz*t2;
			}
			
			r2=(sqr(sx)+sqr(sy)+sqr(sz))^(n/2);
			theta=atan2(sx+flip(sqrt(sqr(sz)+sqr(sy))));
			phi=atan2(sy+flip(sz));
			
			if (sumode) {
				nx=-r2*cos(theta*v);
				ny=-r2*sin(v*theta)*cos(v*phi);
				nz=r2*sin(v*theta)*sin(v*phi);
			} else {
				nx=r2*cos(theta*v);
				ny=r2*sin(v*theta)*cos(v*phi);
				nz=r2*sin(v*theta)*sin(v*phi);
			}
				 if (juliaMode) {
			  sx=nx*scalef+cr;
			 sy=ny*scalef+ci;
			 sz=nz*scalef+cj;
			} else {
			
			 sx=nx*scalef+(pixelr);
			 sy=ny*scalef+abs(pixeli);
			 sz=nz*scalef+(pixelj);
			}
			z=quaternion(sx,sy,sz,0);
			bail=abs(sx)+abs(sy)+abs(sz);
}
	else if (fractaltype=="Amazing Hybrid B4") {
				   if (sx > check) {
                sx = fold - sx;
			} else if (sx<(0-check)) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<(0-check)) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<(0-check)) {
                sz = 0-fold - sz;
			}
             /*fold sphere onto itself   */
              r = (sqr(sx)+sqr(sy)+sqr(sz));
              if (r < sqr(minRadius)) {
                t1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*t1;
			 sy=sy*t1;
			 sz=sz*t1;
			} else if (r < sqr(fixedRadius)) {
                t2=(sqr(fixedRadius)/(r));
                sx=sx*t2;
			 sy=sy*t2;
			 sz=sz*t2;
			}
			
			r2=(sqr(sx)+sqr(sy)+sqr(sz))^(n/2);
			
			theta=atan2(sx+flip(sy));
			tango=atan2(sx+flip(sz)); 
			if ((sy+sz)<0) {
			whiskey=atan2(sx-flip(sqrt(sqr(sy)+sqr(sz))));
			} else {
			whiskey=atan2(sx+flip(sqrt(sqr(sy)+sqr(sz))));
			}
			nx=r2*cos(whiskey*v);
			ny=r2*sin(theta*v);
			nz=r2*sin(tango*v);
			
			 if (juliaMode) {
			  sx=nx*scalef+cr;
			 sy=ny*scalef+ci;
			 sz=nz*scalef+cj;
			} else {
			
			 sx=nx*scalef+(pixelr);
			 sy=ny*scalef+(pixeli);
			 sz=nz*scalef+(pixelj);
			}
			z=quaternion (sx,sy,sz,0);
			bail=abs(sx)+abs(sy)+abs(sz);

}
	
	else if (fractaltype=="Mandelbox") {
	/* fold box onto itself  */
              if (sx > check) {
                sx = fold - sx;
			} else if (sx<(0-check)) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<(0-check)) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<(0-check)) {
                sz = 0-fold - sz;
			}
             /*fold sphere onto itself   */
              r = (sx^2+sy^2+sz^2);
              if (r < sqr(minRadius)) {
                t1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*t1;
			 sy=sy*t1;
			 sz=sz*t1;
			} else if (r < sqr(fixedRadius)) {
                t2=(sqr(fixedRadius)/(r));
                sx=sx*t2;
			 sy=sy*t2;
			 sz=sz*t2;
			}
			if (juliaMode) {
			sx=sx*scalef+cr;
			sy=sy*scalef+ci;
			sz=sz*scalef+cj;
		} else {
			sx=sx*scalef+pixelr;
			sy=sy*scalef+pixeli;
			sz=sz*scalef+pixelj;
		}
		z=quaternion(sx,sy,sz,0);
		bail=abs(sx)+abs(sy)+abs(sz);
	}
	else if (fractaltype=="Mandelbox 2") {
	/* fold box onto itself */
	
              if (sx > check) {
                sx = fold - sx;
			} else if (sx<(0-check)) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<(0-check)) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<(0-check)) {
                sz = 0-fold - sz;
			} 
			
			// fold mags vs stuff
		
		
		if ((sy+sz)<0) {	
		  r=0- sqrt(sqr(sy)+sqr(sz));
			if (r < (0- check)) {
			 ny=0-fold-(sqr(sy)-sqr(sz));
			 nz=0-fold-(2*sy*sz);
			}
			
		} else
		   {
			 r=sqrt(sqr(sy)+sqr(sz));
			if ( r > check) {
                ny= fold - (sqr(sy)-sqr(sz));
			 nz= fold - (2*sy*sz);
			}
		}
           
			
		if ((sx+sy)<0) {	
		  r=0- sqrt(sqr(sx)+sqr(sy));
			if (r < (0- check)) {
			 nx=0-fold-(sqr(sx)-sqr(sy));
			}
			
		} else
		   {
			 r=sqrt(sqr(sx)+sqr(sy));
			if ( r > check) {
                nx= fold - (sqr(sx)-sqr(sy));
			}
		}
			sx=nx;
			sy=ny;
			sz=nz;
			
             /*fold sphere onto itself   */
              r = (sx^2+sy^2+sz^2);
              if (r < sqr(minRadius)) {
                t1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*t1;
			 sy=sy*t1;
			 sz=sz*t1;
			} else if (r < sqr(fixedRadius)) {
                t2=(sqr(fixedRadius)/(r));
                sx=sx*t2;
			 sy=sy*t2;
			 sz=sz*t2;
			}
			if (juliaMode) {
			sx=sx*scalef+cr;
			sy=sy*scalef+ci;
			sz=sz*scalef+cj;
		} else {
			sx=sx*scalef+pixelr;
			sy=sy*scalef+pixeli;
			sz=sz*scalef+pixelj;
		}
		z=quaternion(sx,sy,sz,0);
		bail=abs(sx)+abs(sy)+abs(sz);
	}  else if (fractaltype=="Amazing Hybrid D 4d") {
		  
              if (sx > check) {
                sx = fold - sx;
			} else if (sx<0-check) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<0-check) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<0-check) {
                sz = 0-fold - sz;
			}
			if (sk > check) {
                sk = fold - sk;
			} else if (sk<(0-check)) {
                sk = 0-fold - sk;
			}
             /*fold sphere onto itself   */
			if (mistake) {
               r = (sqr(sx)+sqr(sy)+sqr(sz));
				} else {
			 r = (sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk));
			}
              if (r < sqr(minRadius)) {
                r1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			 sk=sk*r1;
			} else if (r < sqr(fixedRadius)) {
						r1=(sqr(fixedRadius)/(r));
						sx=sx*r1;
				sy=sy*r1;
				sz=sz*r1;
				sk=sk*r1;
				}
		if (lt==1 && pt==1) {		
			if (stringymode) {
				if (absmode) {
				theta=atan2(abs(sx)*checkvar+flip(sqrt((sqr(sz)+sqr(sy)+sqr(sk)))));
				phi=atan2(abs(sy)*checkvar+flip(sqrt((sqr(sx)+sqr(sz)+sqr(sk)))));
				tango=atan2(abs(sz)*checkvar+flip(sqrt ((sqr(sx)+sqr(sy)+sqr(sk)))));
				whiskey=atan2(abs(sk)*checkvar+flip(sqrt ((sqr(sx)+sqr(sy)+sqr(sz)))));
				r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
				sx=r2*sin(v*theta);
				sy=r2*sin(v*phi);
				sz=r2*sin(tango*mag);
				sk=r2*sin(whiskey*mag);
				} else {
				theta=atan2(sx*checkvar+flip(sqrt((sqr(sz)+sqr(sy)+sqr(sk)))));
				phi=atan2(sy*checkvar+flip(sqrt((sqr(sx)+sqr(sz)+sqr(sk)))));
				tango=atan2(sz*checkvar+flip(sqrt ((sqr(sx)+sqr(sy)+sqr(sk)))));
				whiskey=atan2(sk*checkvar+flip(sqrt ((sqr(sx)+sqr(sy)+sqr(sz)))));
				r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
				sx=r2*sin(v*theta);
				sy=r2*sin(v*phi);
				sz=r2*sin(tango*mag);
				sk=r2*sin(whiskey*mag);
			}
			} else {
			if (absmode) {
				theta=atan2(abs(sx)*checkvar+flip(sqrt((sqr(sz)+sqr(sy)+sqr(sk)))));
				phi=atan2(abs(sy)*checkvar+flip(sqrt((sqr(sx)+sqr(sz)+sqr(sk)))));
				tango=atan2(abs(sz)*checkvar+flip(sqrt ((sqr(sx)+sqr(sy)+sqr(sk)))));
				whiskey=atan2(abs(sk)*checkvar+flip(sqrt ((sqr(sx)+sqr(sy)+sqr(sz)))));
			} else {
				theta=atan2(sx*checkvar+flip(sqrt((sqr(sz)+sqr(sy)+sqr(sk)))));
				phi=atan2(sy*checkvar+flip(sqrt((sqr(sx)+sqr(sz)+sqr(sk)))));
				tango=atan2(sz*checkvar+flip(sqrt ((sqr(sx)+sqr(sy)+sqr(sk)))));
				whiskey=atan2(sk*checkvar+flip(sqrt ((sqr(sx)+sqr(sy)+sqr(sz)))));
			}
				r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
			
				r2=(sx^2+sy^2+sz^2)^(n/2);
				sx=r2*cos(v*theta);
				sy=r2*cos(v*phi);
				sz=r2*cos(tango*mag);
				sk=r2*cos(whiskey*mag);
			}
		} else {
				if (stringymode) {
				if (absmode) {
				theta=atan2(abs(sx)^lt*checkvar+flip((sqr(sz)+sqr(sy)+sqr(sk))^(pt/2)));
				phi=atan2(abs(sy)^lt*checkvar+flip((sqr(sx)+sqr(sz)+sqr(sk))^(pt/2)));
				tango=atan2(abs(sz)^lt*checkvar+flip((sqr(sx)+sqr(sy)+sqr(sk))^(pt/2)));
				whiskey=atan2(abs(sk)^lt*checkvar+flip((sqr(sx)+sqr(sy)+sqr(sz))^(pt/2)));
				
				} else {
				theta=atan2(sx^lt*checkvar+flip((sqr(sz)+sqr(sy)+sqr(sk))^(pt/2)));
				phi=atan2(sy^lt*checkvar+flip((sqr(sx)+sqr(sz)+sqr(sk))^(pt/2)));
				tango=atan2(sz^lt*checkvar+flip((sqr(sx)+sqr(sy)+sqr(sk))^(pt/2)));
				whiskey=atan2(sk^lt*checkvar+flip((sqr(sx)+sqr(sy)+sqr(sz))^(pt/2)));
				}
				r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
				sx=r2*sin(v*theta);
				sy=r2*sin(v*phi);
				sz=r2*sin(tango*mag);
				sk=r2*sin(whiskey*mag);
			
			} else {
				if (absmode) {
				theta=atan2(abs(sx)^lt*checkvar+flip((sqr(sz)+sqr(sy)+sqr(sk))^(pt/2)));
				phi=atan2(abs(sy)^lt*checkvar+flip((sqr(sx)+sqr(sz)+sqr(sk))^(pt/2)));
				tango=atan2(abs(sz)^lt*checkvar+flip((sqr(sx)+sqr(sy)+sqr(sk))^(pt/2)));
				whiskey=atan2(abs(sk)^lt*checkvar+flip((sqr(sx)+sqr(sy)+sqr(sz))^(pt/2)));
				
				} else {
				theta=atan2(sx^lt*checkvar+flip((sqr(sz)+sqr(sy)+sqr(sk))^(pt/2)));
				phi=atan2(sy^lt*checkvar+flip((sqr(sx)+sqr(sz)+sqr(sk))^(pt/2)));
				tango=atan2(sz^lt*checkvar+flip((sqr(sx)+sqr(sy)+sqr(sk))^(pt/2)));
				whiskey=atan2(sk^lt*checkvar+flip((sqr(sx)+sqr(sy)+sqr(sz))^(pt/2)));
				}
					r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
			
				sx=r2*cos(v*theta);
				sy=r2*cos(v*phi);
				sz=r2*cos(tango*mag);
				sk=r2*cos(whiskey*mag);
			}
		
		}
			if (juliaMode) {
			sx=sx*scalef+cr;
			sy=sy*scalef+ci;
			sz=sz*scalef+cj;
			sk=sk*scalef+ck;
			} else {
			sx=sx*scalef+pixelr;
			sy=sy*scalef+pixeli;
			sz=sz*scalef+pixelj;
			sk=sk*scalef+pixelk;
			}
			if (bailcontrol) {	
			bail=abs(sx)^bail2+abs(sy)^bail2+abs(sz)^bail2+abs(sk)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			}
		z=quaternion(sx,sy,sz,sk);
		}	 else if (fractaltype=="Mandelbox 4d") {
	/* fold box onto itself  */
              if (sx > check) {
                sx = fold - sx;
			} else if (sx<(0-check)) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<(0-check)) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<(0-check)) {
                sz = 0-fold - sz;
			}
			if (sk > check) {
                sk = fold - sk;
			} else if (sk<(0-check)) {
                sk = 0-fold - sk;
			}
             /*fold sphere onto itself   */
              r = (sx^2+sy^2+sz^2+sk^2);
              if (r < sqr(minRadius)) {
                r1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			 sk=sk*r1;
			} else if (r < sqr(fixedRadius)) {
                r1=(sqr(fixedRadius)/(r));
                sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			 sk=sk*r1;
			}
			if (juliaMode) {
			sx=sx*scalef+cr;
			sy=sy*scalef+ci;
			sz=sz*scalef+cj;
			sk=sk*scalef+ck;
		} else {
			sx=sx*scalef+pixelr;
			sy=sy*scalef+pixeli;
			sz=sz*scalef+pixelj;
			sk=sk*scalef+pixelk;
		}
		z=quaternion(sx,sy,sz,sk);
		bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
	} else if (fractaltype=="Type B Hybrid 4d") {
				/* fold box onto itself  */
                if (sx > check) {
                sx = fold - sx;
			} else if (sx<0-check) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<0-check) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<0-check) {
                sz = 0-fold - sz;
			}
			if (sk > check) {
                sk = fold - sk;
			} else if (sk<(0-check)) {
                sk = 0-fold - sk;
			}
             /*fold sphere onto itself   */
              r = (sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk));
              if (r < sqr(minRadius)) {
                r1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			 sk=sk*r1;
			} else if (r < sqr(fixedRadius)) {
						r1=(sqr(fixedRadius)/(r));
						sx=sx*r1;
				sy=sy*r1;
				sz=sz*r1;
				sk=sk*r1;
				}
			r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
			
			
			 theta=atan2(sx^pt+flip(sy^lt));
		      tango=atan2(sx^pt+flip(sz^lt));
			 whiskey=atan2(sx^pt+flip(sk^lt));
		    if (juliaMode) {
			  sx=r2*cos(theta*mag)*scalef+cr;
		  sy=r2*sin(theta*v)*scalef+ci;
		  sz=r2*sin(tango*v)*scalef+cj;
		  sk=r2*sin(whiskey*v)*scalef+ck;
			} else {
		 sx=r2*cos(theta*mag)*scalef+pixelr;
		  sy=r2*sin(theta*v)*scalef+pixeli;
		  sz=r2*sin(tango*v)*scalef+pixelj;
		   sk=r2*sin(whiskey*v)*scalef+pixelk;
		}
			if (bailcontrol) {	
			bail=abs(sx)^bail2+abs(sy)^bail2+abs(sz)^bail2+abs(sk)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
			}
			z=quaternion(sx,sy,sz,sk);
		}  else if (fractaltype=="Type B Hybrid") {
				/* fold box onto itself  */
               if (sx > check) {
                sx = fold - sx;
			} else if (sx<(0-check)) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<(0-check)) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<(0-check)) {
                sz = 0-fold - sz;
			}
			
             /*fold sphere onto itself   */
              r = (sx^2+sy^2+sz^2);
              if (r < sqr(minRadius)) {
                r1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			} else if (r < sqr(fixedRadius)) {
                r1=(sqr(fixedRadius)/(r));
                sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			}

			r2=(sx^2+sy^2+sz^2)^(n/2);
			
			
			 theta=atan2(sx^pt+flip(sy^lt));
		      tango=atan2(sx^pt+flip(sz^lt));
		    if (juliaMode) {
			  sx=r2*cos(theta*mag)*scalef+cr;
		  sy=r2*sin(theta*v)*scalef+ci;
		  sz=r2*sin(tango*v)*scalef+cj;
			} else {
		 sx=r2*cos(theta*mag)*scalef+pixelr;
		  sy=r2*sin(theta*v)*scalef+pixeli;
		  sz=r2*sin(tango*v)*scalef+pixelj;
		}
			if (bailcontrol) {	
			bail=abs(sx)^bail2+abs(sy)^bail2+abs(sz)^bail2;
			} else {
			bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
			z=quaternion(sx,sy,sz,0);
		} else if (fractaltype=="Amazing Hybrid Bulb1") {
		  
              if (sx > check) {
                sx = fold - sx;
			} else if (sx<0-check) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<0-check) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<0-check) {
                sz = 0-fold - sz;
			}
             /*fold sphere onto itself   */
              r = (sx^2+sy^2+sz^2);
		   
			 if (r < sqr(minRadius)) {
                r1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			} else if (r < fixedRadius) {
                r1=(sqr(fixedRadius)/r);
                sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			}
			
			theta=atan2(sz+flip(sqrt(sqr(sx)+sqr(sy))));
			phi=atan2(sy+flip(sx));
			
			r2=(sx^2+sy^2+sz^2)^(n/2);
			sx=r2*sin(mag*theta)*sin(v*phi);
			sy=r2*sin(theta*mag)*cos(v*phi);
			sz=r2*cos(theta*mag);
			
			if (juliaMode) {
			sx=sx*scalef+cr;
			sy=sy*scalef+ci;
			sz=sz*scalef+cj;
			} else {
			sx=sx*scalef+pixelr;
			sy=sy*scalef+pixeli;
			sz=sz*scalef+pixelj;
			}
			if (bailcontrol) {	
			bail=abs(sx)^bail2+abs(sy)^bail2+abs(sz)^bail2;
			} else {
			bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
			z=quaternion(sx,sy,sz,0);
		
		} else if (fractaltype=="Amazing Hybrid Bulb2") {
		  
              if (sx > check) {
                sx = fold - sx;
			} else if (sx<0-check) {
                sx = 0-fold - sx;
			}
              if (sy > check) {
                sy = fold - sy;
			} else if (sy<0-check) {
                sy = 0-fold - sy;
			}
             if (sz > check) {
                sz = fold - sz;
			} else if (sz<0-check) {
                sz = 0-fold - sz;
			}
             /*fold sphere onto itself   */
              r = (sx^2+sy^2+sz^2);
		   
			 if (r < sqr(minRadius)) {
                r1=(sqr(fixedRadius)/sqr(minRadius));
			 sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			} else if (r < fixedRadius) {
                r1=(sqr(fixedRadius)/r);
                sx=sx*r1;
			 sy=sy*r1;
			 sz=sz*r1;
			}
			
			theta=atan2(sz+flip(sqrt(sqr(sx)+sqr(sy))));
			phi=atan2(sy+flip(sx));
			
			r2=(sx^2+sy^2+sz^2)^(n/2);
			sx=r2*cos(mag*theta)*sin(v*phi);
			sy=r2*cos(theta*mag)*cos(v*phi);
			sz=r2*sin(theta*mag);
			
			
			if (juliaMode) {
			sx=sx*scalef+cr;
			sy=sy*scalef+ci;
			sz=sz*scalef+cj;
			} else {
			sx=sx*scalef+pixelr;
			sy=sy*scalef+pixeli;
			sz=sz*scalef+pixelj;
			}
			if (bailcontrol) {	
			bail=abs(sx)^bail2+abs(sy)^bail2+abs(sz)^bail2;
			} else {
			bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
		z=quaternion(sx,sy,sz,0);
		} 
	}

	bool bailout(void)
	{
		return(bail<bailout);
	}
	
	void description(void)
	{
		this.title="Tom Lowes's Mandelbox and Benesi's variations";
	
		bailout.caption = "Bailout Value";
		bailout.default = 16;
		bailout.min = 0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.  Set high for these fractals as it smooths them out.";
		
		fractaltype.caption="Formula";
		fractaltype.enum="Mandelbox\nMandelbox 2\nMandelbox 4d\nAmazing Mag XYZ\nBF Hybrid\nAmazing Hybrid Correct Bulb\nAmazing Hybrid B4\nAmazing Hybrid D 4d\nType B Hybrid\nType B Hybrid 4d\nAmazing Hybrid Bulb2\nAmazing Hybrid Bulb1";
		fractaltype.default=0;
		fractaltype.hint="If you select Mandala, MAKE SURE TO ROTATE THE FRACTAL EITHER HORIZONTALLY OR VERTICALLY BY 45 DEGREES";
			
		assignment.caption="P.V.A. Mode";
		assignment.enum="Magnitude\n-Magnitude\nLinear Sign Magnitude\nPlanar Sign Magnitude\nComplexitude\n-Complexitude\nLinear Sign Complexitude\nPlanar Sign Complexitude";
		assignment.default=0;
		assignment.hint="Planar variable assignment moded lets you specify how planar variables w, v, and u are assigned.  Leave on magnitude or -magnitude mode for most calculations, play around with complexitude modes for more complicated, albeit somewhat mismatched images";
		
		timemode.caption="Time Mode";
		timemode.enum="Normal\nTotal Mag\n-Total Mag";
		timemode.default=0;
		
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		
		n.caption="n";
		n.default=2;

		

		
				
		scalef.caption="MBOX SCALE";
		scalef.default=2;
		fold.caption="MBOX FOLD";
		fold.default=2;
		minRadius.caption="MBOX MINRADIUS";
		minRadius.default=.5;
		fixedRadius.caption="MBOX FIXEDRADIUS";
		fixedRadius.default=1;
		check.caption="MBOX CHECK";
		check.default=1;
		
		
		c.caption="julia seeds";
		c.default=(0,0,0,0); /*(0.3,-0.44,-0.57,0.3); */
		c.hint="for Julia fractals set values 1,2 and 3 of this and c2";
		c2.caption="4th Dimension";
		c2.default=0;
		c2.hint="change part_k c to c2 for older fractals";
	
	   
		
		stringymode.caption="Make it stringy";
		mistake.caption="Whoops";
		sumode.caption="Switch SU";
		r2mode.caption="Switch A";
		rXmodeb.caption="Switch B";
		rXmodec.caption="Switch C";
		absmode.caption="ABSmode";
		
		 lt.caption="Trig Exponent 1";
		lt.default=1;
		lt.hint="Set to different values to change how angles are calculated.  Can result in interesting images in the Mandala formula, when combined with changing PVA mode.";
		pt.caption="Trig Exponent 2";
		pt.default=1;
		pt.hint="See Linear Trig Hint";
		
		bailcontrol.caption="Bail control mode";
		bailcontrol.default=false;
		bailcontrol.hint="Use if you want to set bail exponents for planar and linear components of bailout.";
	
		bail1.caption="planar bail exponent";
		bail1.default=0;
		bail1.hint="for control of planar values exponent in bail control mode, use with Mandalamode for some awesome fractals";
		bail2.caption="linear bail exponent";
		bail2.default=1;
		bail2.hint="See bail exponent wvu hint as well, if you set one of these to a negative value 1 less than the other, cool stuff can happen in mandalamode";

		}
}





cp_16458(QUATERNION) { 
/*  Copyright Matthew Benesi   All Rights Reserved  */
/*  These formulas are only authorized for distribution with ChaosPro */
/*  Derivative works may not be distributed without authors permission   */
/*  2/11/2010 */
parameter real bailout;
parameter quaternion perturb;
parameter quaternion c;
parameter real c2,c3,partcl;
real sx,sy,sz;
real sk,sl,st;
real nk,nl,nt;
real nx,ny,nz;
real r,r1,r2,r3,r4,r5,r6,bail;
parameter int fractaltype;
parameter int assignment,timemode,colormode,r2mode;
real cr,ci,cj,ck,cl,i,ct;
complex victor,bravo,cramden,fluffy,ralph;  
real theta,phi,tango,whiskey,foxtrot,gamma;
real pixelr,pixeli,pixelj,pixelk,pixell;
parameter real n;
parameter bool juliaMode,absmode;

	void init(void)
	{
	  	
		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		ck=part_k(c);
		cl=partcl;
		
		if (absmode) {
			pixelr=(part_r(pixel));
			pixeli=abs(part_i(pixel));
			pixelj=abs(part_j(pixel));
		} else {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
		}
		if (timemode=="Total Mag") {
		pixelk=sqrt(pixelr^2+pixeli^2+pixelj^2+pixell^2);
		pixell=sqrt(pixelr^2+pixeli^2+pixelj^2+pixelk^2);
		} else if (timemode=="-Total Mag") {
		pixelk=0-sqrt(pixelr^2+pixeli^2+pixelj^2+pixell^2);
		pixell=sqrt(pixelr^2+pixeli^2+pixelj^2+pixelk^2);
		} else if (timemode=="Normal") {
		pixelk=c2;
		pixell=c3;
		}

		if (juliaMode) {
			if (r2mode=="Normal 1") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelj;
						sk=pixelk;
						sl=pixell;
				} else if (r2mode=="Normal 2") {
						sx=pixelr;
						sy=pixelk;
						sz=pixeli;
						sk=pixell;
						sl=pixelj;
				} else if (r2mode=="Normal 3") {
						sx=nx+ck;
						sy=ny+cl;
						sz=nz+cr;
						sk=nk+ci;
						sl=nl+cj;
				} else if (r2mode=="r2 mode 1") {
						sx=pixelr;
						sy=pixell;
						sz=pixeli;
						sk=pixelk;
						sl=pixelj;
				} else if (r2mode=="r2 mode 2") {
						sx=pixelk;
						sy=pixelr;
						sz=pixeli;
						sk=pixelj;
						sl=pixell;
				} else if (r2mode=="r2 mode 3") {
						sx=pixell;
						sy=pixelk;
						sz=pixelr;
						sk=pixeli;
						sl=pixelj;
				}
		
		} else {
			sx=cr;
			sy=ci;
			sz=cj;
			sk=ck;
			sl=cl;
		}
		
		 
	}
	void loop(void)
	{
	if (fractaltype=="Beautiful Fractal 5d") {
		victor=complex(sx,sqrt(sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl)));
		bravo=complex(sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)),sl);
		cramden=complex(sqrt(sqr(sx)+sqr(sy)+sqr(sz)),sk);
		ralph=complex(sqrt(sqr(sx)+sqr(sy)),sz);
		fluffy=complex(sx,sy);
		
		r1=cabs(cramden)^-n;
		r2=cabs(ralph)^-n;
		r3=cabs(fluffy)^-n;
		victor=victor^n;
		bravo=bravo^n;
		cramden=cramden^n;
		ralph=ralph^n;
		fluffy=fluffy^n;
		
		nx=part_r(victor);
		ny=-abs(part_i(bravo));
		r1=abs(part_r(bravo))*r1;
		nl=-abs(part_i(cramden))*r1;
		r2=abs(part_r(cramden))*r1*r2;
		nk=-abs(part_i(ralph))*r2;
		r3=abs(part_r(ralph))*r2*r3;
		nz=-abs(part_i(fluffy))*r3;

		
			if (juliaMode) {
				if (r2mode=="Normal 1") {
						sx=nx+cr;
						sy=ny+ci;
						sz=nz+cj;
						sk=nk+ck;
						sl=nl+cl;
				} else if (r2mode=="Normal 2") {
						sx=nx+cr;
						sy=ny+ck;
						sz=nz+ci;
						sk=nk+cl;
						sl=nl+cj;
				} else if (r2mode=="Normal 3") {
						sx=nx+ck;
						sy=ny+cl;
						sz=nz+cr;
						sk=nk+ci;
						sl=nl+cj;
				} else if (r2mode=="r2 mode 1") {
						sx=sx-nx+cr;
						sy=sy-ny+cl;
						sz=sz-nz+ci;
						sk=sl-nk+ck;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode 2") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+ci;
						sk=sk-nk+cj;
						sl=sl-nl+cl;
				} else if (r2mode=="r2 mode 3") {
						sx=sx-nx+cl;
						sy=sy-ny+ck;
						sz=sz-nz+cr;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode 4") {
						sx=-sx+nx+cl;
						sy=-sy+ny+ck;
						sz=sz-nz+cr;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
				}
			} else {
			   if (r2mode=="r2 mode 1") {
						sx=nx+(pixelr);
						sy=ny+sy+abs(pixell);
						sz=nz+abs(pixeli);
						sk=nk+sk+abs(pixelk);
						sl=nl+abs(pixelj);
				} else if (r2mode=="r2 mode 2") {
						sx=nx+sx+abs(pixelk);
						sy=ny+(pixelr);
						sz=nz+abs(pixeli);
						sk=nk+abs(pixelj);
						sl=nl+sl+abs(pixell);
				} else if (r2mode=="r2 mode 3") {
						sx=nx+sx+abs(pixell);
						sy=ny+sy+abs(pixelk);
						sz=nz+(pixelr);
						sk=nk+abs(pixeli);
						sl=nl+abs(pixelj);
				} else if (r2mode=="r2 mode 4") {
						sx=sx-nx+abs(pixell);
						sy=sy-ny+abs(pixelk);
						sz=nz+(pixelr);
						sk=nk+abs(pixeli);
						sl=nl+abs(pixelj);
				} else if (r2mode=="Normal 1") {
						sx=nx+(pixelr);
						sy=ny+abs(pixeli);
						sz=nz+abs(pixelj);
						sk=nk+abs(pixelk);
						sl=nl+abs(pixell);
				} else if (r2mode=="Normal 2") {
						sx=nx+(pixelr);
						sy=ny+abs(pixelk);
						sz=nz+abs(pixeli);
						sk=nk+abs(pixell);
						sl=nl+abs(pixelj);
				} else if (r2mode=="Normal 3") {
						sx=nx+abs(pixelk);
						sy=ny+abs(pixell);
						sz=nz+(pixelr);
						sk=nk+abs(pixeli);
						sl=nl+abs(pixelj);
				}
			}
			if (colormode=="Complex 1") {
				z=quaternion(real(victor),real(bravo),real(cramden),imag(cramden));
			} else if (colormode=="Complex 2") {
				z=quaternion(real(victor),real(bravo),real(cramden),real(fluffy));
			} else if (colormode=="Complex 3") {
				z=quaternion(imag(victor),imag(bravo),imag(cramden),imag(fluffy));
			} else if (colormode=="Mag, x, y, z") {
				r=sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
				if (r2mode=="Normal 1") {
					z=quaternion(r,sx,sy,sz);
				} else if (r2mode=="Normal 2") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="Normal 3") {
					z=quaternion(r,sz,sk,sl);
				} else if (r2mode=="r2 mode 1") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="r2 mode 2") {
					z=quaternion(r,sy,sz,sk);
				} else if (r2mode=="r2 mode 3") {
					z=quaternion(r,sz,sk,sl);
				} else if (r2mode=="r2 mode 4") {
					z=quaternion(r,sz,sk,sl);
				} 
			}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk)+abs(sl);
			
		}
		else if (fractaltype=="Complex Compound 5d") {
			r1=sqrt(sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
			r2=sqrt(sqr(sz)+sqr(sk)+sqr(sl));
			r3=sqrt(sqr(sk)+sqr(sl));
			if (n==11) {
				r4=sqr(sqr(sqr(r1)))*sqr(r1)*r1;
			} else if (n==13) {
				r4=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*r1;
			} else if (n==15) {
				r4=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*sqr(r1)*r1;
			} else if (n==16) {
				r4=sqr(sqr(sqr(sqr(r1))));
			} else if (n==17) {
				r4=sqr(sqr(sqr(sqr(r1))))*r1;
			}  else {
				r4=r1^n;
			} 
			r4=r4^(-1);
			if (n==11) {
				r5=sqr(sqr(sqr(r2)))*sqr(r2)*r2;
			} else if (n==13) {
				r5=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*r2;
			} else if (n==15) {
				r5=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==16) {
				r5=sqr(sqr(sqr(sqr(r2))));
			} else if (n==17) {
				r5=sqr(sqr(sqr(sqr(r2))))*r2;
			}  else {
				r5=r2^n;
			} 
			r5=r5^-1;
			if (n==11) {
				r6=sqr(sqr(sqr(r3)))*sqr(r3)*r3;
			} else if (n==13) {
				r6=sqr(sqr(sqr(r3)))*sqr(sqr(r3))*r3;
			} else if (n==15) {
				r6=sqr(sqr(sqr(r3)))*sqr(sqr(r3))*sqr(r3)*r3;
			} else if (n==16) {
				r6=sqr(sqr(sqr(sqr(r3))));
			} else if (n==17) {
				r6=sqr(sqr(sqr(sqr(r3))))*r3;
			}  else {
				r6=r3^n;
			} 
			r6=r6^-1;
			
			victor=complex(sx,r1);
			bravo=complex(sy,r2);
			cramden=complex(sz,r3);
			fluffy=complex(sk,sl);
		if (n==11) {
				victor=sqr(sqr(sqr(victor)))*sqr(victor)*victor;
			} else if (n==13) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*victor;
			} else if (n==15) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*sqr(victor)*victor;
			} else if (n==16) {
				victor=sqr(sqr(sqr(sqr(victor))));
			} else if (n==17) {
				victor=sqr(sqr(sqr(sqr(victor))))*victor;
			}  else {
				victor=victor^n;
			} 
			if (n==11) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(bravo)*bravo;
			} else if (n==13) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*bravo;
			} else if (n==15) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*sqr(bravo)*bravo;
			} else if (n==16) {
				bravo=sqr(sqr(sqr(sqr(bravo))));
			} else if (n==17) {
				bravo=sqr(sqr(sqr(sqr(bravo))))*bravo;
			}  else {
				bravo=bravo^n;
			} 
			if (n==11) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(cramden)*cramden;
			} else if (n==13) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*cramden;
			} else if (n==15) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*sqr(cramden)*cramden;
			} else if (n==16) {
				cramden=sqr(sqr(sqr(sqr(cramden))));
			} else if (n==17) {
				cramden=sqr(sqr(sqr(sqr(cramden))))*cramden;
			}  else {
				cramden=cramden^n;
			} 
			
			if (n==11) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(fluffy)*fluffy;
			} else if (n==13) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(sqr(fluffy))*fluffy;
			} else if (n==15) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(sqr(fluffy))*sqr(fluffy)*fluffy;
			} else if (n==16) {
				fluffy=sqr(sqr(sqr(sqr(fluffy))));
			} else if (n==17) {
				fluffy=sqr(sqr(sqr(sqr(fluffy))))*fluffy;
			}  else {
				fluffy=fluffy^n;
			} 
			
				nx=part_r(victor);
				r4=r4*part_i(victor);
				ny=r4*part_r(bravo);
				r5=r4*r5*part_i(bravo);
				nz=part_r(cramden)*r5;
				r6=r5*r6*part_i(cramden);
				nk=part_r(fluffy)*r6;
				nl=part_i(fluffy)*r6;
			
			if (juliaMode) {
				if (r2mode=="Normal 1") {
						sx=nx+cr;
						sy=ny+ci;
						sz=nz+cj;
						sk=nk+ck;
						sl=nl+cl;
				} else if (r2mode=="Normal 2") {
						sx=nx+cr;
						sy=ny+ck;
						sz=nz+ci;
						sk=nk+cl;
						sl=nl+cj;
				} else if (r2mode=="Normal 3") {
						sx=nx+ck;
						sy=ny+cl;
						sz=nz+cr;
						sk=nk+ci;
						sl=nl+cj;
				} else if (r2mode=="r2 mode 1") {
						sx=sx-nx+cr;
						sy=sy-ny+cl;
						sz=sz-nz+ci;
						sk=sl-nk+ck;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode 2") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+ci;
						sk=sk-nk+cj;
						sl=sl-nl+cl;
				} else if (r2mode=="r2 mode 3") {
						sx=sx-nx+cl;
						sy=sy-ny+ck;
						sz=sz-nz+cr;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode 4") {
						sx=-sx+nx+cl;
						sy=-sy+ny+ck;
						sz=sz-nz+cr;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
				}
			} else {
			   if (r2mode=="r2 mode 1") {
						sx=nx+(pixelr);
						sy=ny+sy+(pixell);
						sz=nz+(pixeli);
						sk=nk+sk+(pixelk);
						sl=nl+pixelj;
				} else if (r2mode=="r2 mode 2") {
						sx=nx+sx+(pixelk);
						sy=ny+(pixelr);
						sz=nz+(pixeli);
						sk=nk+(pixelj);
						sl=nl+sl+pixell;
				} else if (r2mode=="r2 mode 3") {
						sx=nx+sx+pixell;
						sy=ny+sy+(pixelk);
						sz=nz+(pixelr);
						sk=nk+(pixeli);
						sl=nl+pixelj;
				} else if (r2mode=="r2 mode 4") {
						sx=sx-nx+pixell;
						sy=sy-ny+(pixelk);
						sz=nz+(pixelr);
						sk=nk+(pixeli);
						sl=nl+pixelj;
				} else if (r2mode=="Normal 1") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+(pixelk);
						sl=nl+pixell;
				} else if (r2mode=="Normal 2") {
						sx=nx+(pixelr);
						sy=ny+(pixelk);
						sz=nz+(pixeli);
						sk=nk+(pixell);
						sl=nl+pixelj;
				} else if (r2mode=="Normal 3") {
						sx=nx+(pixelk);
						sy=ny+(pixell);
						sz=nz+(pixelr);
						sk=nk+(pixeli);
						sl=nl+pixelj;
				}
			}
			if (colormode=="Complex 1") {
				z=quaternion(real(victor),real(bravo),real(cramden),imag(cramden));
			} else if (colormode=="Complex 2") {
				z=quaternion(real(victor),real(bravo),real(cramden),real(fluffy));
			} else if (colormode=="Complex 3") {
				z=quaternion(imag(victor),imag(bravo),imag(cramden),imag(fluffy));
			} else if (colormode=="Mag, x, y, z") {
				r=sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
				if (r2mode=="Normal 1") {
					z=quaternion(r,sx,sy,sz);
				} else if (r2mode=="Normal 2") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="Normal 3") {
					z=quaternion(r,sz,sk,sl);
				} else if (r2mode=="r2 mode 1") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="r2 mode 2") {
					z=quaternion(r,sy,sz,sk);
				} else if (r2mode=="r2 mode 3") {
					z=quaternion(r,sz,sk,sl);
				} else if (r2mode=="r2 mode 4") {
					z=quaternion(r,sz,sk,sl);
				} 
			}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk)+abs(sl);
			
		} 
		else if (fractaltype=="Burning Ship 5d") {
			r1=sqrt(sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
			r2=sqrt(sqr(sz)+sqr(sk)+sqr(sl));
			r3=sqrt(sqr(sk)+sqr(sl));
			if (n==11) {
				r4=sqr(sqr(sqr(r1)))*sqr(r1)*r1;
			} else if (n==13) {
				r4=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*r1;
			} else if (n==15) {
				r4=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*sqr(r1)*r1;
			} else if (n==16) {
				r4=sqr(sqr(sqr(sqr(r1))));
			} else if (n==17) {
				r4=sqr(sqr(sqr(sqr(r1))))*r1;
			}  else {
				r4=r1^n;
			} 
			r4=r4^(-1);
			if (n==11) {
				r5=sqr(sqr(sqr(r2)))*sqr(r2)*r2;
			} else if (n==13) {
				r5=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*r2;
			} else if (n==15) {
				r5=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==16) {
				r5=sqr(sqr(sqr(sqr(r2))));
			} else if (n==17) {
				r5=sqr(sqr(sqr(sqr(r2))))*r2;
			}  else {
				r5=r2^n;
			} 
			r5=r5^-1;
			if (n==11) {
				r6=sqr(sqr(sqr(r3)))*sqr(r3)*r3;
			} else if (n==13) {
				r6=sqr(sqr(sqr(r3)))*sqr(sqr(r3))*r3;
			} else if (n==15) {
				r6=sqr(sqr(sqr(r3)))*sqr(sqr(r3))*sqr(r3)*r3;
			} else if (n==16) {
				r6=sqr(sqr(sqr(sqr(r3))));
			} else if (n==17) {
				r6=sqr(sqr(sqr(sqr(r3))))*r3;
			}  else {
				r6=r3^n;
			} 
			r6=r6^-1;
			
			victor=complex(sx,r1);
			bravo=complex(sy,r2);
			cramden=complex(sz,r3);
			fluffy=complex(sk,sl);
		if (n==11) {
				victor=sqr(sqr(sqr(victor)))*sqr(victor)*victor;
			} else if (n==13) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*victor;
			} else if (n==15) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*sqr(victor)*victor;
			} else if (n==16) {
				victor=sqr(sqr(sqr(sqr(victor))));
			} else if (n==17) {
				victor=sqr(sqr(sqr(sqr(victor))))*victor;
			}  else {
				victor=victor^n;
			} 
			if (n==11) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(bravo)*bravo;
			} else if (n==13) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*bravo;
			} else if (n==15) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*sqr(bravo)*bravo;
			} else if (n==16) {
				bravo=sqr(sqr(sqr(sqr(bravo))));
			} else if (n==17) {
				bravo=sqr(sqr(sqr(sqr(bravo))))*bravo;
			}  else {
				bravo=bravo^n;
			} 
			if (n==11) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(cramden)*cramden;
			} else if (n==13) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*cramden;
			} else if (n==15) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*sqr(cramden)*cramden;
			} else if (n==16) {
				cramden=sqr(sqr(sqr(sqr(cramden))));
			} else if (n==17) {
				cramden=sqr(sqr(sqr(sqr(cramden))))*cramden;
			}  else {
				cramden=cramden^n;
			} 
			
			if (n==11) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(fluffy)*fluffy;
			} else if (n==13) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(sqr(fluffy))*fluffy;
			} else if (n==15) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(sqr(fluffy))*sqr(fluffy)*fluffy;
			} else if (n==16) {
				fluffy=sqr(sqr(sqr(sqr(fluffy))));
			} else if (n==17) {
				fluffy=sqr(sqr(sqr(sqr(fluffy))))*fluffy;
			}  else {
				fluffy=fluffy^n;
			} 
			nx=part_r(victor);
			r4=abs(r4*part_i(victor));
			ny=r4*part_r(bravo);
			r5=abs(r4*r5*part_i(bravo));
			nz=part_r(cramden)*r5;
			r6=abs(r5*r6*part_i(cramden));
			nk=part_r(fluffy)*r6;
			nl=part_i(fluffy)*r6;
		
			if (juliaMode) {
				if (r2mode=="Normal 1") {
						sx=nx+cr;
						sy=ny+ci;
						sz=nz+cj;
						sk=nk+ck;
						sl=nl+cl;
				} else if (r2mode=="Normal 2") {
						sx=nx+cr;
						sy=ny+ck;
						sz=nz+ci;
						sk=nk+cl;
						sl=nl+cj;
				} else if (r2mode=="Normal 3") {
						sx=nx+ck;
						sy=ny+cl;
						sz=nz+cr;
						sk=nk+ci;
						sl=nl+cj;
				} else if (r2mode=="r2 mode 1") {
						sx=sx-nx+cr;
						sy=sy-ny+cl;
						sz=sz-nz+ci;
						sk=sl-nk+ck;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode 2") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+ci;
						sk=sk-nk+cj;
						sl=sl-nl+cl;
				} else if (r2mode=="r2 mode 3") {
						sx=sx-nx+cl;
						sy=sy-ny+ck;
						sz=sz-nz+cr;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode 4") {
						sx=-sx+nx+cl;
						sy=-sy+ny+ck;
						sz=sz-nz+cr;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
				}
			} else {
			   if (r2mode=="r2 mode 1") {
						sx=nx+(pixelr);
						sy=(ny)-sy+(pixell);
						sz=abs(nz)-(pixeli);
						sk=(nk)-sk+(pixelk);
						sl=abs(nl)-pixelj;
				} else if (r2mode=="r2 mode 2") {
						sx=(nx)+(sz)+(pixelk);
						sy=ny+(pixelr);
						sz=abs(nz)-(pixeli);
						sk=abs(nk)-(pixelj);
						sl=(nl)+sk+pixell;
				} else if (r2mode=="r2 mode 3") {
						sx=nx+sk+pixelk;
						sy=ny+sl+(pixell);
						sz=nz+(pixelr);
						sk=abs(nk)-(pixeli);
						sl=abs(nl)-pixelj;
				} else if (r2mode=="r2 mode 4") {
						sx=nx+(pixelr);
						sy=abs(ny)-(pixeli);
						sz=abs(nz)-(pixelj);
						sk=nk+sy+(pixelk);
						sl=nl+sz+pixell;
				} else if (r2mode=="Normal 1") {
						sx=nx+(pixelr);
						sy=abs(ny)-(pixeli);
						sz=abs(nz)-(pixelj);
						sk=nk+(pixelk);
						sl=nl+pixell;
				} else if (r2mode=="Normal 2") {
						sx=nx+(pixelr);
						sy=ny+(pixelk);
						sz=abs(nz)-(pixeli);
						sk=nk+(pixell);
						sl=abs(nl)-pixelj;
				} else if (r2mode=="Normal 3") {
						sx=nx+(pixelk);
						sy=ny+(pixell);
						sz=nz+(pixelr);
						sk=abs(nk)-(pixeli);
						sl=abs(nl)-pixelj;
				}
			}
			if (colormode=="Complex 1") {
				z=quaternion(real(victor),real(bravo),real(cramden),imag(cramden));
			} else if (colormode=="Complex 2") {
				z=quaternion(real(victor),real(bravo),real(cramden),real(fluffy));
			} else if (colormode=="Complex 3") {
				z=quaternion(imag(victor),imag(bravo),imag(cramden),imag(fluffy));
			} else if (colormode=="Mag, x, y, z") {
				r=sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
				if (r2mode=="Normal 1") {
					z=quaternion(r,sx,sy,sz);
				} else if (r2mode=="Normal 2") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="Normal 3") {
					z=quaternion(r,sz,sk,sl);
				} else if (r2mode=="r2 mode 1") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="r2 mode 2") {
					z=quaternion(r,sy,sz,sk);
				} else if (r2mode=="r2 mode 3") {
					z=quaternion(r,sz,sk,sl);
				} else if (r2mode=="r2 mode 4") {
					z=quaternion(r,sz,sk,sl);
				} 
			}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk)+abs(sl);
			
		}
		else if (fractaltype=="Mandelbrot 5d") {
			r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
			
			if (r2mode) {
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz)+sqr(sk))));		
				phi=atan2((sy)+flip(sqrt(sqr(sz)+sqr(sk))));
				tango= atan2((sz)+flip((sk)));
			} else {
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz)+sqr(sk))));		
				phi=atan2(abs(sy)+flip(sqrt(sqr(sz)+sqr(sk))));
				tango= atan2(abs(sz)+flip(abs(sk)));
			}
			nx=r2*cos(theta*n);
			ny=r2*sin(theta*n)*cos(phi*n);
			nz=r2*sin(theta*n)*sin(phi*n)*cos(tango*n);
			nk=r2*sin(theta*n)*sin(phi*n)*sin(tango*n);
				
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sz=nk+ck;
			} else {
				sx=nx+(pixelr);
				sy=ny+abs(pixeli);
				sz=nz+abs(pixelj);
				sk=nk+abs(pixelk);
			}
			z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
		}
	 
	}

	bool bailout(void)
	{
		return(bail<bailout);
	}
	
	void description(void)
	{
		this.title="5 D Benesi Set";
		bailout.caption = "Bailout Value";
		bailout.default = 16;
		bailout.min = 0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.  Set high for these fractals as it smooths them out.";
		
		fractaltype.caption="Formula";
		fractaltype.enum="Beautiful Fractal 5d\nBurning Ship 5d\nComplex Compound 5d\nMandelbrot 5d";
		fractaltype.default=0;
		fractaltype.hint="If you select Mandala, MAKE SURE TO ROTATE THE FRACTAL EITHER HORIZONTALLY OR VERTICALLY BY 45 DEGREES";
			
		assignment.caption="P.V.A. Mode";
		assignment.enum="Magnitude\n-Magnitude\nLinear Sign Magnitude\nPlanar Sign Magnitude\nComplexitude\n-Complexitude\nLinear Sign Complexitude\nPlanar Sign Complexitude";
		assignment.default=0;
		assignment.hint="Planar variable assignment moded lets you specify how planar variables w, v, and u are assigned.  Leave on magnitude or -magnitude mode for most calculations, play around with complexitude modes for more complicated, albeit somewhat mismatched images";
		
		timemode.caption="Time Mode";
		timemode.enum="Normal\nTotal Mag\n-Total Mag";
		timemode.default=0;
		
		r2mode.caption="R2 Mode";
		r2mode.enum="Normal 1\nr2 mode 1\nr2 mode 2\nr2 mode 3\nr2 mode 4\nNormal 2\nNormal 3";
		
		colormode.caption="Color Mode";
		colormode.enum="Complex 1\nComplex 2\nComplex 3\nMag, x, y, z";
		
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		
		n.caption="n";
		n.default=2;
		n.hint="z^n.  n is the angular multiplier (rotation) and magnitude applied to the fractal formula.";
		
	
		c.caption="c";
		c.default=(0,0,0,0); /*(0.3,-0.44,-0.57,0.3); */
		c.hint="for Julia fractals set values 1,2 and 3 of this and c2";
		partcl.caption="c (part 5):";
		c2.caption="part k c2:";
		c2.default=0;
		c2.hint="change part_k c to c2 for older fractals";
		c3.caption="part l c3:";
		}
}


cp_66584(QUATERNION) { 
/*  Copyright Matthew Benesi   All Rights Reserved  */
/*  These formulas are only authorized for distribution with ChaosPro */
/*  Derivative works may not be distributed without authors permission   */
/*  2/11/2010 */
parameter real bailout;
parameter quaternion perturb;
parameter quaternion c;
parameter real c2,c3,partcl;
real sx,sy,sz;
real sk,sl,st;
real nk,nl,nt;
real nx,ny,nz;
real r,r1,r2,r3,r4,r5,r6,bail;
int increments;
parameter int fractaltype,r2modeB,countincrements;
parameter int assignment,timemode,colormode,r2mode;
parameter int absmodeyp,absmodeyn,absmodezn,absmodezp,absmodekn,absmodekp,absmodeln,absmodelp;
real cr,ci,cj,ck,cl,i,ct,iterinv,count;
complex victor,bravo,cramden,fluffy;  
real theta,phi,tango,whiskey,foxtrot,gamma;
real pixelr,pixeli,pixelj,pixelk,pixell;
parameter real n,countexp,countstart,countincrement;
parameter bool juliaMode;

	void init(void)
	{
	  	
		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		ck=part_k(c);
		cl=partcl;
		count=countstart;
		increments=0;
		pixelr=part_r(pixel);
		pixeli=part_i(pixel);
		pixelj=part_j(pixel);
		if (timemode=="Total Mag") {
		pixelk=sqrt(pixelr^2+pixeli^2+pixelj^2+pixell^2);
		pixell=sqrt(pixelr^2+pixeli^2+pixelj^2+pixelk^2);
		} else if (timemode=="-Total Mag") {
		pixelk=0-sqrt(pixelr^2+pixeli^2+pixelj^2+pixell^2);
		pixell=sqrt(pixelr^2+pixeli^2+pixelj^2+pixelk^2);
		} else if (timemode=="Normal") {
		pixelk=c2;
		pixell=c3;
		}

		if (juliaMode) {
			if (r2mode=="Normal 1") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelj;
						sk=pixelk;
						sl=pixell;
				} else if (r2mode=="Normal 2") {
						sx=pixelr;
						sy=pixelk;
						sz=pixeli;
						sk=pixell;
						sl=pixelj;
				} else if (r2mode=="Normal 3") {
						sx=nx+ck;
						sy=ny+cl;
						sz=nz+cr;
						sk=nk+ci;
						sl=nl+cj;
				} else if (r2mode=="r2 mode yz") {
						sx=pixelr;
						sy=pixelk;
						sz=pixell;
						sk=pixeli;
						sl=pixelj;
				} else if (r2mode=="r2 mode yk") {
						sx=pixelr;
						sy=pixelk;
						sz=pixeli;
						sk=pixell;
						sl=pixelj;
				} else if (r2mode=="r2 mode yl") {
						sx=pixelr;
						sy=pixelk;
						sz=pixeli;
						sk=pixelj;
						sl=pixell;
				} else if (r2mode=="r2 mode xy") {
						sx=pixelk;
						sy=pixell;
						sz=pixelr;
						sk=pixeli;
						sl=pixelj;
				} else if (r2mode=="r2 mode xz") {
						sx=pixelk;
						sy=pixelr;
						sz=pixell;
						sk=pixeli;
						sl=pixelj;
				} else if (r2mode=="r2 mode xk") {
						sx=pixelk;
						sy=pixelr;
						sz=pixeli;
						sk=pixell;
						sl=pixelj;
				} else if (r2mode=="r2 mode xl") {
						sx=pixelk;
						sy=pixelr;
						sz=pixeli;
						sk=pixelj;
						sl=pixell;
				} else if (r2mode=="r2 mode zk") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelk;
						sk=pixell;
						sl=pixelj;
				} else if (r2mode=="r2 mode zl") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelk;
						sk=pixelj;
						sl=pixell;
				} else if (r2mode=="r2 mode kl") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelj;
						sk=pixelk;
						sl=pixell;
				}
		
		} else {
			sx=cr;
			sy=ci;
			sz=cj;
			sk=ck;
			sl=cl;
		}
		
		 
	}
	void loop(void)
	{
	if (fractaltype=="Complex Compound 5d") {
			r1=sqrt(sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
			r2=sqrt(sqr(sz)+sqr(sk)+sqr(sl));
			r3=sqrt(sqr(sk)+sqr(sl));
			if (n<11) {
				r4=r1^n;
			} else if (n==11) {
				r4=sqr(sqr(sqr(r1)))*sqr(r1)*r1;
			} else if (n==13) {
				r4=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*r1;
			} else if (n==15) {
				r4=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*sqr(r1)*r1;
			} else if (n==16) {
				r4=sqr(sqr(sqr(sqr(r1))));
			} else if (n==17) {
				r4=sqr(sqr(sqr(sqr(r1))))*r1;
			}  else {
				r4=r1^n;
			} 
			r4=r4^(-1);
			if (n<11) {
				r5=r2^n;
			} else if (n==11) {
				r5=sqr(sqr(sqr(r2)))*sqr(r2)*r2;
			} else if (n==13) {
				r5=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*r2;
			} else if (n==15) {
				r5=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==16) {
				r5=sqr(sqr(sqr(sqr(r2))));
			} else if (n==17) {
				r5=sqr(sqr(sqr(sqr(r2))))*r2;
			}  else {
				r5=r2^n;
			} 
			r5=r5^-1;
			if (n<11) {
				r6=r3^n;
			} else if (n==11) {
				r6=sqr(sqr(sqr(r3)))*sqr(r3)*r3;
			} else if (n==13) {
				r6=sqr(sqr(sqr(r3)))*sqr(sqr(r3))*r3;
			} else if (n==15) {
				r6=sqr(sqr(sqr(r3)))*sqr(sqr(r3))*sqr(r3)*r3;
			} else if (n==16) {
				r6=sqr(sqr(sqr(sqr(r3))));
			} else if (n==17) {
				r6=sqr(sqr(sqr(sqr(r3))))*r3;
			}  else {
				r6=r3^n;
			} 
			r6=r6^-1;
			
			victor=complex(sx,r1);
			bravo=complex(sy,r2);
			cramden=complex(sz,r3);
			fluffy=complex(sk,sl);
			if (n<11) {
				victor=victor^n;
			} else if (n==11) {
				victor=sqr(sqr(sqr(victor)))*sqr(victor)*victor;
			} else if (n==13) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*victor;
			} else if (n==15) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*sqr(victor)*victor;
			} else if (n==16) {
				victor=sqr(sqr(sqr(sqr(victor))));
			} else if (n==17) {
				victor=sqr(sqr(sqr(sqr(victor))))*victor;
			}  else {
				victor=victor^n;
			} 
			if (n<11) {
				bravo=bravo^n;
			} else if (n==11) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(bravo)*bravo;
			} else if (n==13) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*bravo;
			} else if (n==15) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*sqr(bravo)*bravo;
			} else if (n==16) {
				bravo=sqr(sqr(sqr(sqr(bravo))));
			} else if (n==17) {
				bravo=sqr(sqr(sqr(sqr(bravo))))*bravo;
			}  else {
				bravo=bravo^n;
			} 
			if (n<11) {
				cramden=cramden^n;
			} else if (n==11) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(cramden)*cramden;
			} else if (n==13) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*cramden;
			} else if (n==15) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*sqr(cramden)*cramden;
			} else if (n==16) {
				cramden=sqr(sqr(sqr(sqr(cramden))));
			} else if (n==17) {
				cramden=sqr(sqr(sqr(sqr(cramden))))*cramden;
			}  else {
				cramden=cramden^n;
			} 
			if (n<11) {
				fluffy=fluffy^n;
			} else if (n==11) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(fluffy)*fluffy;
			} else if (n==13) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(sqr(fluffy))*fluffy;
			} else if (n==15) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(sqr(fluffy))*sqr(fluffy)*fluffy;
			} else if (n==16) {
				fluffy=sqr(sqr(sqr(sqr(fluffy))));
			} else if (n==17) {
				fluffy=sqr(sqr(sqr(sqr(fluffy))))*fluffy;
			}  else {
				fluffy=fluffy^n;
			} 
			
			nx=part_r(victor);
			r4=part_i(victor)*r4;
			r5=part_i(bravo)*r4*r5;
			r6=r5*part_i(cramden)*r6;
			
			nk=r6*part_r(fluffy);
			nl=r6*part_i(fluffy);
			
			if (sy<0) {
					if (absmodeyn=="- abs") {
						ny=-(r4)*abs(part_r(bravo)); //default for all
					} else if (absmodeyn=="+ r3abs abs") {
						ny=abs(r4)*abs(part_r(bravo)); 
					} else if (absmodeyn=="- r3abs abs") {
						ny=-abs(r4)*abs(part_r(bravo));  
					} else if (absmodeyn=="+ r3abs no abs") {
						ny=abs(r4)*(part_r(bravo)); 
					} else if (absmodeyn=="- r3abs no abs") {
						ny=-abs(r4)*(part_r(bravo));  
					} else if (absmodeyn=="+ abs") {
						ny=(r4)*abs(part_r(bravo));
					} else if (absmodeyn=="- no abs") {
						ny=-(r4)*(part_r(bravo));
					} else if (absmodeyn=="+ no abs") {
						ny=(r4)*(part_r(bravo));  
					}
				} else {	
					if (absmodeyp=="- abs") {
						ny=-(r4)*abs(part_r(bravo)); //default for 4,8,12.... alternate all others
					} else if (absmodeyp=="+ r3abs abs") {
						ny=abs(r4)*abs(part_r(bravo)); 
					} else if (absmodeyp=="- r3abs abs") {
						ny=-abs(r4)*abs(part_r(bravo));  
					} else if (absmodeyp=="+ r3abs no abs") {
						ny=abs(r4)*(part_r(bravo)); 
					} else if (absmodeyp=="- r3abs no abs") {
						ny=-abs(r4)*(part_r(bravo));  
					} else if (absmodeyp=="+ abs") {
						ny=(r4)*abs(part_r(bravo));
					} else if (absmodeyp=="- no abs") {
						ny=-(r4)*(part_r(bravo));
					} else if (absmodeyp=="+ no abs") {
						ny=(r4)*(part_r(bravo));  //default for 2,3,5,6,7,9,10,11....
					}
				} 
				
				if (sz<0) {
					if (absmodezn=="- abs") {
						nz=-(r5)*abs(part_i(bravo)); //default for 2,6,10,14.... alternate all others
					} else if (absmodezn=="+ r3abs abs") {
						nz=abs(r5)*abs(part_i(bravo));  //default all others, alternate 2,6,10,14...
					} else if (absmodezn=="- r3abs abs") {
						nz=-abs(r5)*abs(part_i(bravo));  
					} else if (absmodezn=="+ r3abs no abs") {
						nz=abs(r5)*(part_i(bravo));  //default all others, alternate 2,6,10,14...
					} else if (absmodezn=="- r3abs no abs") {
						nz=-abs(r5)*(part_i(bravo));  
					} else if (absmodezn=="+ abs") {
						nz=(r5)*abs(part_i(bravo));
					} else if (absmodezn=="- no abs") {
						nz=-(r5)*(part_i(bravo));
					} else if (absmodezn=="+ no abs") {
						nz=(r5)*(part_i(bravo));
					}
				} else {
					if (absmodezp=="- abs") {
						nz=-(r5)*abs(part_i(bravo)); 
					} else if (absmodezp=="+ r3abs abs") {
						nz=abs(r5)*abs(part_i(bravo)); 
					} else if (absmodezp=="- r3abs abs") {
						nz=-abs(r5)*abs(part_i(bravo));  //default all others, alternate 2,6,10,14...
					} else if (absmodezp=="+ r3abs no abs") {
						nz=abs(r5)*(part_i(bravo)); 
					} else if (absmodezp=="- r3abs no abs") {
						nz=-abs(r5)*(part_i(bravo));  //default all others, alternate 2,6,10,14...
					} else if (absmodezp=="+ abs") {
						nz=(r5)*abs(part_i(bravo));//default for 2,6,10,14.... alternate all others
					} else if (absmodezp=="- no abs") {
						nz=-(r5)*(part_i(bravo));
					} else if (absmodezp=="+ no abs") {
						nz=(r5)*(part_i(bravo));  
					}
				}

				if (sk<0) {
					if (absmodekn=="- abs") {
						nk=-(r6)*abs(part_r(fluffy)); //default for all
					} else if (absmodekn=="+ r3abs abs") {
						nk=abs(r6)*abs(part_r(fluffy)); 
					} else if (absmodekn=="- r3abs abs") {
						nk=-abs(r6)*abs(part_r(fluffy));  
					} else if (absmodekn=="+ r3abs no abs") {
						nk=abs(r6)*(part_r(fluffy)); 
					} else if (absmodekn=="- r3abs no abs") {
						nk=-abs(r6)*(part_r(fluffy));  
					} else if (absmodekn=="+ abs") {
						nk=(r6)*abs(part_r(fluffy));
					} else if (absmodekn=="- no abs") {
						nk=-(r6)*(part_r(fluffy));
					} else if (absmodekn=="+ no abs") {
						nk=(r6)*(part_r(fluffy));  
					}
				} else {	
					if (absmodekp=="- abs") {
						nk=-(r6)*abs(part_r(fluffy)); //default for 4,8,12.... alternate all others
					} else if (absmodekp=="+ r3abs abs") {
						nk=abs(r6)*abs(part_r(fluffy)); 
					} else if (absmodekp=="- r3abs abs") {
						nk=-abs(r6)*abs(part_r(fluffy));  
					} else if (absmodekp=="+ r3abs no abs") {
						nk=abs(r6)*(part_r(fluffy)); 
					} else if (absmodekp=="- r3abs no abs") {
						nk=-abs(r6)*(part_r(fluffy));  
					} else if (absmodekp=="+ abs") {
						nk=(r6)*abs(part_r(fluffy));
					} else if (absmodekp=="- no abs") {
						nk=-(r6)*(part_r(fluffy));
					} else if (absmodekp=="+ no abs") {
						nk=(r6)*(part_r(fluffy));  //default for 2,3,5,6,7,9,10,11....
					}
				} 
				
			
				if (sl<0) {
					if (absmodeln=="- abs") {
						nl=-(r6)*abs(part_i(fluffy)); //default for all
					} else if (absmodeln=="+ r3abs abs") {
						nl=abs(r6)*abs(part_i(fluffy)); 
					} else if (absmodeln=="- r3abs abs") {
						nl=-abs(r6)*abs(part_i(fluffy));  
					} else if (absmodeln=="+ r3abs no abs") {
						nl=abs(r6)*(part_i(fluffy)); 
					} else if (absmodeln=="- r3abs no abs") {
						nl=-abs(r6)*(part_i(fluffy));  
					} else if (absmodeln=="+ abs") {
						nl=(r6)*abs(part_i(fluffy));
					} else if (absmodeln=="- no abs") {
						nl=-(r6)*(part_i(fluffy));
					} else if (absmodeln=="+ no abs") {
						nl=(r6)*(part_i(fluffy));  
					}
				} else {	
					if (absmodelp=="- abs") {
						nl=-(r6)*abs(part_i(fluffy)); //default for 4,8,12.... alternate all others
					} else if (absmodelp=="+ r3abs abs") {
						nl=abs(r6)*abs(part_i(fluffy)); 
					} else if (absmodelp=="- r3abs abs") {
						nl=-abs(r6)*abs(part_i(fluffy));  
					} else if (absmodelp=="+ r3abs no abs") {
						nl=abs(r6)*(part_i(fluffy)); 
					} else if (absmodelp=="- r3abs no abs") {
						nl=-abs(r6)*(part_i(fluffy));  
					} else if (absmodelp=="+ abs") {
						nl=(r6)*abs(part_i(fluffy));
					} else if (absmodelp=="- no abs") {
						nl=-(r6)*(part_i(fluffy));
					} else if (absmodelp=="+ no abs") {
						nl=(r6)*(part_i(fluffy));  //default for 2,3,5,6,7,9,10,11....
					}
				} 
				
			
			if (juliaMode) {
				if (r2mode=="Normal 1") {
						sx=nx+cr;
						sy=ny+ci;
						sz=nz+cj;
						sk=nk+ck;
						sl=nl+cl;
				} else if (r2mode=="Normal 2") {
						sx=nx+cr;
						sy=ny+ck;
						sz=nz+ci;
						sk=nk+cl;
						sl=nl+cj;
				} else if (r2mode=="Normal 3") {
						sx=nx+ck;
						sy=ny+cl;
						sz=nz+cr;
						sk=nk+ci;
						sl=nl+cj;
				} else if (r2mode=="r2 mode yz") {
						sx=sx-nx+cr;
						sy=sy-ny+ck;
						sz=sz-nz+cl;
						sk=sl-nk+ci;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode yk") {
						sx=sx-nx+cr;
						sy=sy-ny+ck;
						sz=sz-nz+ci;
						sk=sl-nk+cl;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode yl") {
						sx=sx-nx+cr;
						sy=sy-ny+ck;
						sz=sz-nz+ci;
						sk=sl-nk+cj;
						sl=sl-nl+cl;
				} else if (r2mode=="r2 mode xy") {
						sx=sx-nx+ck;
						sy=sy-ny+cl;
						sz=sz-nz+cr;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode xz") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+cl;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode xk") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+ci;
						sk=sk-nk+cl;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode xl") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+ci;
						sk=sk-nk+cj;
						sl=sl-nl+cl;
				} else if (r2mode=="r2 mode zk") {
						sx=sx-nx+cr;
						sy=sy-ny+ci;
						sz=sz-nz+ck;
						sk=sk-nk+cl;
						sl=sl-nl+cj;
				} else if (r2mode=="r2 mode zl") {
						sx=sx-nx+cr;
						sy=sy-ny+ci;
						sz=sz-nz+ck;
						sk=sk-nk+cj;
						sl=sl-nl+cl;
				} else if (r2mode=="r2 mode kl") {
						sx=sx-nx+cr;
						sy=sy-ny+ci;
						sz=sz-nz+cj;
						sk=sk-nk+ck;
						sl=sl-nl+cl;
				}
			} else {
				if (r2mode=="r2 mode xy") {
				     if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+(pixell)*iterinv;
						sz=-nz+sz+(pixelr)*iterinv;
						sk=-nk+sk+(pixeli)*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+(pixell)*iterinv;
						sz=nz+sz+(pixelr)*iterinv;
						sk=nk+sk+(pixeli)*iterinv;
						sl=nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+sy+(pixell);
						sz=nz+(pixelr);
						sk=nk+(pixeli);
						sl=nl+pixelj;
					}
				} else if (r2mode=="Normal 1") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+(pixelk);
						sl=nl+pixell;
				} else if (r2mode=="r2 mode xz") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+(pixelr)*iterinv;
						sz=-nz+sz+(pixell)*iterinv;
						sk=-nk+sk+(pixeli)*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+(pixelr)*iterinv;
						sz=nz+sz+(pixell)*iterinv;
						sk=nk+sk+(pixeli)*iterinv;
						sl=nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+(pixelr);
						sz=nz+sz+(pixell);
						sk=nk+(pixeli);
						sl=nl+pixelj;
					}
				} else if (r2mode=="r2 mode xk") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+(pixelr)*iterinv;
						sz=-nz+sz+(pixeli)*iterinv;
						sk=-nk+sk+(pixell)*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+(pixelr)*iterinv;
						sz=nz+sz+(pixeli)*iterinv;
						sk=nk+sk+(pixell)*iterinv;
						sl=nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+(pixelk);
						sy=ny+(pixelr);
						sz=nz+(pixeli);
						sk=nk+sk+(pixell);
						sl=nl+pixelj;
					}
				}  else if (r2mode=="r2 mode xl") {
						if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+(pixelr)*iterinv;
						sz=-nz+sz+(pixeli)*iterinv;
						sk=-nk+sk+pixelj*iterinv;
						sl=-nl+sl+(pixell)*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+(pixelr)*iterinv;
						sz=nz+sz+(pixeli)*iterinv;
						sk=nk+sk+pixelj*iterinv;
						sl=nl+sl+(pixell)*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+(pixelk);
						sy=ny+(pixelr);
						sz=nz+(pixeli);
						sk=nk+(pixelj);
						sl=nl+sl+pixell;
					}
				} else if (r2mode=="r2 mode yz") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixelk*iterinv;
						sz=-nz+sz+pixell*iterinv;
						sk=-nk+sk+pixeli*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixelk*iterinv;
						sz=nz+sz+pixell*iterinv;
						sk=nk+sk+pixeli*iterinv;
						sl=nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+(pixelr);
						sy=ny+sy+(pixelk);
						sz=nz+sz+(pixell);
						sk=nk+(pixeli);
						sl=nl+pixelj;
					}
				}  else if (r2mode=="r2 mode yk") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixelk*iterinv;
						sz=-nz+sz+pixeli*iterinv;
						sk=-nk+sk+pixell*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixelk*iterinv;
						sz=nz+sz+pixeli*iterinv;
						sk=nk+sk+pixell*iterinv;
						sl=nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+(pixelr);
						sy=ny+sy+(pixelk);
						sz=nz+(pixeli);
						sk=nk+sk+(pixell);
						sl=nl+pixelj;
					}
				} else if (r2mode=="r2 mode yl") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixelk*iterinv;
						sz=-nz+sz+pixeli*iterinv;
						sk=-nk+sk+pixelj*iterinv;
						sl=-nl+sl+pixell*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixelk*iterinv;
						sz=nz+sz+pixeli*iterinv;
						sk=nk+sk+pixelj*iterinv;
						sl=nl+sl+pixell*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+(pixelr);
						sy=ny+sy+(pixelk);
						sz=nz+(pixeli);
						sk=nk+pixelj;
						sl=nl+sl+(pixell);
					}
				} else if (r2mode=="r2 mode zk") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixeli*iterinv;
						sz=-nz+sz+pixelk*iterinv;
						sk=-nk+sk+pixell*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixeli*iterinv;
						sz=nz+sz+pixelk*iterinv;
						sk=nk+sk+pixell*iterinv;
						sl=nl+sl+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+sz+(pixelk);
						sk=nk+sk+(pixell);
						sl=nl+pixelj;
					}
				} else if (r2mode=="r2 mode zl") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixeli*iterinv;
						sz=-nz+sz+pixelk*iterinv;
						sk=-nk+sk+pixelj*iterinv;
						sl=-nl+sl+pixell*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixeli*iterinv;
						sz=nz+sz+pixelk*iterinv;
						sk=nk+sk+pixelj*iterinv;
						sl=nl+sl+pixell*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+sz+(pixelk);
						sk=nk+pixelj;
						sl=nl+sl+(pixell);
					}
				} else if (r2mode=="r2 mode kl") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixeli*iterinv;
						sz=-nz+sz+pixelj*iterinv;
						sk=-nk+sk+pixelk*iterinv;
						sl=-nl+sl+pixell*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixeli*iterinv;
						sz=nz+sz+pixelj*iterinv;
						sk=nk+sk+pixelk*iterinv;
						sl=nl+sl+pixell*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+pixelj;
						sk=nk+sk+(pixelk);
						sl=nl+sl+(pixell);
					}
				}  else if (r2mode=="Normal 2") {
						sx=nx+(pixelr);
						sy=ny+(pixelk);
						sz=nz+(pixeli);
						sk=nk+(pixell);
						sl=nl+pixelj;
				} else if (r2mode=="Normal 3") {
						sx=nx+(pixelk);
						sy=ny+(pixell);
						sz=nz+(pixelr);
						sk=nk+(pixeli);
						sl=nl+pixelj;
				}
			}
			if (colormode=="Complex Real") {
				z=quaternion(real(victor),real(bravo),real(cramden),real(fluffy));
			} else if (colormode=="Complex Mag (wrong)") {
				z=quaternion(cabs(victor),cabs(bravo),cabs(cramden),cabs(fluffy));
			} else if (colormode=="Complex Imag") {
				z=quaternion(imag(victor),imag(bravo),imag(cramden),imag(fluffy));
			} else if (colormode=="Mag, x, y, z") {
				r=sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
				if (r2mode=="Normal 1") {
					z=quaternion(r,sx,sy,sz);
				} else if (r2mode=="Normal 2") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="Normal 3") {
					z=quaternion(r,sz,sk,sl);
				} else if (r2mode=="r2 mode yk") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="r2 mode yz") {
					z=quaternion(r,sx,sk,sl);
				} else if (r2mode=="r2 mode yl") {
					z=quaternion(r,sx,sk,sz);
				} else if (r2mode=="r2 mode xl") {
					z=quaternion(r,sy,sz,sk);
				} else if (r2mode=="r2 mode xy") {
					z=quaternion(r,sz,sk,sl);
				} else if (r2mode=="r2 mode xz") {
					z=quaternion(r,sy,sk,sl);
				} else if (r2mode=="r2 mode xk") {
					z=quaternion(r,sy,sz,sl);
				} else if (r2mode=="r2 mode zk") {
					z=quaternion(r,sx,sy,sl);
				} else if (r2mode=="r2 mode zl") {
					z=quaternion(r,sx,sy,sk);
				} else if (r2mode=="r2 mode kl") {
					z=quaternion(r,sx,sy,sz);
				}
			} else if (colormode=="Mag, x, yk, zl") {
				r=sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
				if (r2mode=="Normal 1") {
					z=quaternion(r,sx,sqrt(sqr(sy)+sqr(sk)),sqrt(sqr(sz)+sqr(sl)));
				} else if (r2mode=="Normal 2") {
					z=quaternion(r,sx,sqrt(sqr(sy)+sqr(sz)),sqrt(sqr(sk)+sqr(sl)));
				} else if (r2mode=="Normal 3") {
					z=quaternion(r,sz,sqrt(sqr(sx)+sqr(sk)),sqrt(sqr(sy)+sqr(sl)));
				} else if (r2mode=="r2 mode yk") {
					z=quaternion(r,sx,sqrt(sqr(sy)+sqr(sz)),sqrt(sqr(sk)+sqr(sl)));
				} else if (r2mode=="r2 mode yz") {
					z=quaternion(r,sx,sqrt(sqr(sy)+sqr(sk)),sqrt(sqr(sz)+sqr(sl)));
				} else if (r2mode=="r2 mode yl") {
					z=quaternion(r,sx,sqrt(sqr(sy)+sqr(sk)),sqrt(sqr(sz)+sqr(sl)));
				} else if (r2mode=="r2 mode xl") {
					z=quaternion(r,sy,sqrt(sqr(sx)+sqr(sz)),sqrt(sqr(sk)+sqr(sl)));
				} else if (r2mode=="r2 mode xy") {
					z=quaternion(r,sz,sqrt(sqr(sx)+sqr(sk)),sqrt(sqr(sy)+sqr(sl)));
				} else if (r2mode=="r2 mode xz") {
					z=quaternion(r,sy,sqrt(sqr(sx)+sqr(sk)),sqrt(sqr(sz)+sqr(sl)));
				} else if (r2mode=="r2 mode xk") {
					z=quaternion(r,sy,sqrt(sqr(sx)+sqr(sz)),sqrt(sqr(sk)+sqr(sl)));
				} else if (r2mode=="r2 mode zk") {
					z=quaternion(r,sx,sqrt(sqr(sy)+sqr(sz)),sqrt(sqr(sk)+sqr(sl)));
				} else if (r2mode=="r2 mode zl") {
					z=quaternion(r,sx,sqrt(sqr(sy)+sqr(sz)),sqrt(sqr(sk)+sqr(sl)));
				} else if (r2mode=="r2 mode kl") {
					z=quaternion(r,sx,sqrt(sqr(sy)+sqr(sk)),sqrt(sqr(sz)+sqr(sl)));
				}
			}  else if (colormode=="Mag, nx,ny,nz") {
				r=sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
				if (r2mode=="Normal 1") {
					z=quaternion(r,nx,ny,nz);
				} else if (r2mode=="Normal 2") {
					z=quaternion(r,nx,nz,nl);
				} else if (r2mode=="Normal 3") {
					z=quaternion(r,nz,nk,nl);
				} else if (r2mode=="r2 mode yk") {
					z=quaternion(r,nx,nz,nl);
				} else if (r2mode=="r2 mode yz") {
					z=quaternion(r,nx,nk,nl);
				} else if (r2mode=="r2 mode yl") {
					z=quaternion(r,nx,nk,nz);
				} else if (r2mode=="r2 mode xl") {
					z=quaternion(r,ny,nz,nk);
				} else if (r2mode=="r2 mode xy") {
					z=quaternion(r,nz,nk,nl);
				} else if (r2mode=="r2 mode xz") {
					z=quaternion(r,ny,nk,nl);
				} else if (r2mode=="r2 mode xk") {
					z=quaternion(r,ny,nz,nl);
				} else if (r2mode=="r2 mode zk") {
					z=quaternion(r,nx,ny,nl);
				} else if (r2mode=="r2 mode zl") {
					z=quaternion(r,nx,ny,nk);
				} else if (r2mode=="r2 mode kl") {
					z=quaternion(r,nx,ny,nz);
				}
			} else if (colormode=="Mag,nx,nyk,nzl") {
				r=sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl));
				if (r2mode=="Normal 1") {
					z=quaternion(r,nx,sqrt(sqr(ny)+sqr(nk)),sqrt(sqr(nz)+sqr(nl)));
				} else if (r2mode=="Normal 2") {
					z=quaternion(r,nx,sqrt(sqr(ny)+sqr(nz)),sqrt(sqr(nk)+sqr(nl)));
				} else if (r2mode=="Normal 3") {
					z=quaternion(r,nz,sqrt(sqr(nx)+sqr(nk)),sqrt(sqr(ny)+sqr(nl)));
				} else if (r2mode=="r2 mode yk") {
					z=quaternion(r,nx,sqrt(sqr(ny)+sqr(nz)),sqrt(sqr(nk)+sqr(nl)));
				} else if (r2mode=="r2 mode yz") {
					z=quaternion(r,nx,sqrt(sqr(ny)+sqr(nk)),sqrt(sqr(nz)+sqr(nl)));
				} else if (r2mode=="r2 mode yl") {
					z=quaternion(r,nx,sqrt(sqr(ny)+sqr(nk)),sqrt(sqr(nz)+sqr(nl)));
				} else if (r2mode=="r2 mode xl") {
					z=quaternion(r,ny,sqrt(sqr(nx)+sqr(nz)),sqrt(sqr(nk)+sqr(nl)));
				} else if (r2mode=="r2 mode xy") {
					z=quaternion(r,nz,sqrt(sqr(nx)+sqr(nk)),sqrt(sqr(ny)+sqr(nl)));
				} else if (r2mode=="r2 mode xz") {
					z=quaternion(r,ny,sqrt(sqr(nx)+sqr(nk)),sqrt(sqr(nz)+sqr(nl)));
				} else if (r2mode=="r2 mode xk") {
					z=quaternion(r,ny,sqrt(sqr(nx)+sqr(nz)),sqrt(sqr(nk)+sqr(nl)));
				} else if (r2mode=="r2 mode zk") {
					z=quaternion(r,nx,sqrt(sqr(ny)+sqr(nz)),sqrt(sqr(nk)+sqr(nl)));
				} else if (r2mode=="r2 mode zl") {
					z=quaternion(r,nx,sqrt(sqr(ny)+sqr(nz)),sqrt(sqr(nk)+sqr(nl)));
				} else if (r2mode=="r2 mode kl") {
					z=quaternion(r,nx,sqrt(sqr(ny)+sqr(nk)),sqrt(sqr(nz)+sqr(nl)));
				}
				
			}
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk)+abs(sl);
			
		}
		else if (fractaltype=="Mandelbrot 5d") {
			r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
			
			if (r2mode) {
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz)+sqr(sk))));		
				phi=atan2((sy)+flip(sqrt(sqr(sz)+sqr(sk))));
				tango= atan2((sz)+flip((sk)));
			} else {
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz)+sqr(sk))));		
				phi=atan2(abs(sy)+flip(sqrt(sqr(sz)+sqr(sk))));
				tango= atan2(abs(sz)+flip(abs(sk)));
			}
			nx=r2*cos(theta*n);
			ny=r2*sin(theta*n)*cos(phi*n);
			nz=r2*sin(theta*n)*sin(phi*n)*cos(tango*n);
			nk=r2*sin(theta*n)*sin(phi*n)*sin(tango*n);
				
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sz=nk+ck;
			} else {
				sx=nx+(pixelr);
				sy=ny+abs(pixeli);
				sz=nz+abs(pixelj);
				sk=nk+abs(pixelk);
			}
			z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
		}
	 
	}

	bool bailout(void)
	{
		return(bail<bailout);
	}
	
	void description(void)
	{
		this.title="5 D Benesi Set +";
		bailout.caption = "Bailout Value";
		bailout.default = 16;
		bailout.min = 0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.  Set high for these fractals as it smooths them out.";
		
		fractaltype.caption="Formula";
		fractaltype.enum="Complex Compound 5d\nMandelbrot 5d";
		fractaltype.default=0;
		fractaltype.hint="If you select Mandala, MAKE SURE TO ROTATE THE FRACTAL EITHER HORIZONTALLY OR VERTICALLY BY 45 DEGREES";
			
		assignment.caption="P.V.A. Mode";
		assignment.enum="Magnitude\n-Magnitude\nLinear Sign Magnitude\nPlanar Sign Magnitude\nComplexitude\n-Complexitude\nLinear Sign Complexitude\nPlanar Sign Complexitude";
		assignment.default=0;
		assignment.hint="Planar variable assignment moded lets you specify how planar variables w, v, and u are assigned.  Leave on magnitude or -magnitude mode for most calculations, play around with complexitude modes for more complicated, albeit somewhat mismatched images";
		
		timemode.caption="Time Mode";
		timemode.enum="Normal\nTotal Mag\n-Total Mag";
		timemode.default=0;
		
		r2mode.caption="R2 Mode";
		r2mode.enum="Normal 1\nr2 mode xy\nr2 mode xz\nr2 mode xk\nr2 mode xl\nr2 mode yz\nr2 mode yk\nr2 mode yl\nr2 mode zk\nr2 mode zl\nr2 mode kl\nNormal 2\nNormal 3";
		r2modeB.caption="R2 Mode B";
		r2modeB.enum="none\n+ new\n- new";
		
		colormode.caption="Color Mode";
		colormode.enum="Mag, x, y, z\nMag, x, yk, zl\nComplex Real\nComplex Mag (wrong)\nMag, nx,ny,nz\nMag,nx,nyk,nzl\nComplex Imag";
		
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		
		n.caption="n";
		n.default=2;
		n.hint="z^n.  n is the angular multiplier (rotation) and magnitude applied to the fractal formula.";
		
	
		c.caption="c";
		c.default=(0,0,0,0); /*(0.3,-0.44,-0.57,0.3); */
		c.hint="for Julia fractals set values 1,2 and 3 of this and c2";
		partcl.caption="c (part 5):";
		c2.caption="part k c2:";
		c2.default=0;
		c2.hint="change part_k c to c2 for older fractals";
		c3.caption="part l c3:";
		
		
		
		absmodeyn.caption="absmode y-";
		absmodeyn.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodeyn.hint="- abs is a good default setting for all fractals (including best n=2)(preserves continuity)";
	
		absmodeyp.caption="absmode y+";
		absmodeyp.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodeyp.hint="+ no abs is good for all (including best n=2) except n=4,8,12,16...  - abs is a better default setting for n=4,8,12,16 and a good alternate for all others, for n=5,9,13... - r3abs abs is very nice!";
		absmodeyp.default=6;
		
		absmodezn.caption="absmode z-";
		absmodezn.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodezn.hint="+ r3abs abs is a good default setting for all fractals except n=????..., for n=??2,6,10?? you can use + abs, which is a good alternate for all others.  The best n=2 is -r3abs no abs or (maybe) +r3abs no abs (which is good for n=4 as well)!!!";
		absmodezn.default=2;
			
		absmodezp.caption="absmode z+";
		absmodezp.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodezp.default=3;
		absmodezp.hint="- r3abs abs is a good default for all except 2,6,10,14... use + abs for 2,6,10,14... also + abs is a good alternate for all others.  The best n=2 and maybe n=4? is -r3abs no abs!!!";
		
		absmodekn.caption="absmode y-";
		absmodekn.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodekn.hint="- abs is a good default setting for all fractals (including best n=2)(preserves continuity)";
	
		absmodekp.caption="absmode y+";
		absmodekp.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodekp.hint="+ no abs is good for all (including best n=2) except n=4,8,12,16...  - abs is a better default setting for n=4,8,12,16 and a good alternate for all others, for n=5,9,13... - r3abs abs is very nice!";
		absmodekp.default=6;
		
		absmodeln.caption="absmode z-";
		absmodeln.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodeln.hint="+ r3abs abs is a good default setting for all fractals except n=????..., for n=??2,6,10?? you can use + abs, which is a good alternate for all others.  The best n=2 is -r3abs no abs or (maybe) +r3abs no abs (which is good for n=4 as well)!!!";
		absmodeln.default=2;
			
		absmodelp.caption="absmode z+";
		absmodelp.enum="- abs\n+ abs\n+ r3abs abs\n- r3abs abs\n+ abs\n- no abs\n+ no abs\n+ r3abs no abs\n- r3abs no abs";
		absmodelp.default=3;
		absmodelp.hint="- r3abs abs is a good default for all except 2,6,10,14... use + abs for 2,6,10,14... also + abs is a good alternate for all others.  The best n=2 and maybe n=4? is -r3abs no abs!!!";
		
		
		countstart.caption="Count Start:";
		countstart.default=1;
		countstart.hint="Starting number to divide pixel values by for r2modeB fractal varieties";
		countincrements.caption="# of Counts";
		countincrements.default=33;
		countincrements.hint="Number of times to increase count value by count increment, for 5 iterations of count increase, use a value of 5";
		countincrement.caption="Count +:";
		countincrement.default=1;
		countincrement.hint="Increments count by a specific number each iteration.";
		countexp.caption="Count ^-n:";
		countexp.default=2;
		countexp.hint="For pixel/Count set to 1.  For pixel/count^2 set to 2... etc.";
		
		
		}
}


cp_29424(QUATERNION) { 
/*  Copyright Matthew Benesi   All Rights Reserved  */
/*  These formulas are only authorized for distribution with ChaosPro */
/*  Derivative works may not be distributed without authors permission   */
/*  2/11/2010 */
parameter real bailout;
parameter quaternion perturb;
parameter quaternion c;
parameter real c2,c3,c4,partcl,partcm;
real sx,sy,sz;
real sk,sl,sm,st;
real nk,nl,nm,nt;
real nx,ny,nz;
real r,r1,r2,r3,r4,r5,r6,r7,r8,bail;
int increments;
parameter int fractaltype,r2modeB,countincrements;
parameter int assignment,timemode,colormode,r2mode;
real cr,ci,cj,ck,cl,cm,i,ct,iterinv,count;
complex victor,bravo,cramden,fluffy,muffin;  
real theta,phi,tango,whiskey,foxtrot,gamma;
real pixelr,pixeli,pixelj,pixelk,pixell,pixelm;
parameter real n,countexp,countstart,countincrement;
parameter bool juliaMode;

	void init(void)
	{
	  	
		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		ck=part_k(c);
		cl=partcl;
		cm=partcm;
		count=countstart;
		increments=0;
		pixelr=part_r(pixel);
		pixeli=part_i(pixel);
		pixelj=part_j(pixel);
		if (timemode=="Total Mag") {
		pixelk=sqrt(pixelr^2+pixeli^2+pixelj^2+pixell^2);
		pixell=sqrt(pixelr^2+pixeli^2+pixelj^2+pixelk^2);
		} else if (timemode=="-Total Mag") {
		pixelk=0-sqrt(pixelr^2+pixeli^2+pixelj^2+pixell^2);
		pixell=sqrt(pixelr^2+pixeli^2+pixelj^2+pixelk^2);
		} else if (timemode=="Normal") {
		pixelk=c2;
		pixell=c3;
		pixelm=c4;
		} else if (timemode=="Special 1") {
		pixelk=(pixeli+pixelj)/2;
		pixell=(pixelr+pixelj)/2;
		pixelm=(pixelr+pixeli)/2;
		} else if (timemode=="Special 2") {
		pixelk=sqrt(sqr(pixeli)+sqr(pixelj));
		pixell=sqrt(sqr(pixelr)+sqr(pixelj));
		pixelm=sqrt(sqr(pixelr)+sqr(pixeli));
		} else if (timemode=="-Special 2") {
		pixelk=-sqrt(sqr(pixeli)+sqr(pixelj));
		pixell=-sqrt(sqr(pixelr)+sqr(pixelj));
		pixelm=-sqrt(sqr(pixelr)+sqr(pixeli));
		}

		if (juliaMode) {
			if (r2mode=="Normal 1") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelj;
						sk=pixelk;
						sl=pixell;
						sm=pixelm;
				} else if (r2mode=="Normal 2") {
						sx=pixelr;
						sy=pixelk;
						sz=pixeli;
						sk=pixell;
						sl=pixelj;
						sm=pixelm;
				} else if (r2mode=="Normal 3") {
						sx=pixelr;
						sy=pixelk;
						sz=pixeli;
						sk=pixell;
						sl=pixelj;
						sm=pixelm;
				} else if (r2mode=="r2 mode xyz") {
						sx=pixelk;
						sy=pixell;
						sz=pixelm;
						sk=pixelr;
						sl=pixeli;
						sm=pixelj;
				} else if (r2mode=="r2 mode xyk") {
						sx=pixelk;
						sy=pixell;
						sz=pixelr;
						sk=pixelm;
						sl=pixeli;
						sm=pixelj;
				} else if (r2mode=="r2 mode xyl") {
						sx=pixelk;
						sy=pixell;
						sz=pixelr;
						sk=pixeli;
						sl=pixelm;
						sm=pixelj;
				} else if (r2mode=="r2 mode xym") {
						sx=pixelk;
						sy=pixell;
						sz=pixelr;
						sk=pixeli;
						sl=pixelj;
						sm=pixelm;
				} else if (r2mode=="r2 mode xzk") {
						sx=pixelk;
						sy=pixelr;
						sz=pixell;
						sk=pixelm;
						sl=pixeli;
						sm=pixelj;
				} else if (r2mode=="r2 mode xzl") {
						sx=pixelk;
						sy=pixelr;
						sz=pixell;
						sk=pixeli;
						sl=pixelm;
						sm=pixelj;
				} else if (r2mode=="r2 mode xzm") {
						sx=pixelk;
						sy=pixelr;
						sz=pixell;
						sk=pixeli;
						sl=pixelj;
						sm=pixelm;
				} else if (r2mode=="r2 mode xkl") {
						sx=pixelk;
						sy=pixelr;
						sz=pixeli;
						sk=pixell;
						sl=pixelm;
						sm=pixelj;
				} else if (r2mode=="r2 mode xkm") {
						sx=pixelk;
						sy=pixelr;
						sz=pixeli;
						sk=pixell;
						sl=pixelj;
						sm=pixelm;
				} else if (r2mode=="r2 mode xlm") {
						sx=pixelk;
						sy=pixelr;
						sz=pixeli;
						sk=pixelj;
						sl=pixell;
						sm=pixelm;
				} else if (r2mode=="r2 mode yzk") {
						sx=pixelr;
						sy=pixelk;
						sz=pixell;
						sk=pixelm;
						sl=pixeli;
						sm=pixelj;
				} else if (r2mode=="r2 mode yzl") {
						sx=pixelr;
						sy=pixelk;
						sz=pixell;
						sk=pixeli;
						sl=pixelm;
						sm=pixelj;
				} else if (r2mode=="r2 mode yzm") {
						sx=pixelr;
						sy=pixelk;
						sz=pixell;
						sk=pixeli;
						sl=pixelj;
						sm=pixelm;
				} else if (r2mode=="r2 mode ykl") {
						sx=pixelr;
						sy=pixelk;
						sz=pixeli;
						sk=pixell;
						sl=pixelm;
						sm=pixelj;
				} else if (r2mode=="r2 mode ykm") {
						sx=pixelr;
						sy=pixelk;
						sz=pixeli;
						sk=pixell;
						sl=pixelj;
						sm=pixelm;
				} else if (r2mode=="r2 mode ylm") {
						sx=pixelr;
						sy=pixelk;
						sz=pixeli;
						sk=pixelj;
						sl=pixell;
						sm=pixelm;
				} else if (r2mode=="r2 mode zkl") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelk;
						sk=pixell;
						sl=pixelm;
						sm=pixelj;
				} else if (r2mode=="r2 mode zkm") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelk;
						sk=pixell;
						sl=pixelj;
						sm=pixelm;
				} else if (r2mode=="r2 mode zlm") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelk;
						sk=pixelj;
						sl=pixell;
						sm=pixelm;
				} else if (r2mode=="r2 mode klm") {
						sx=pixelr;
						sy=pixeli;
						sz=pixelj;
						sk=pixelk;
						sl=pixell;
						sm=pixelm;
				}
		
		} else {
			sx=cr;
			sy=ci;
			sz=cj;
			sk=ck;
			sl=cl;
			sm=cm;
		}
		
		 
	}
	void loop(void)
	{
	if (fractaltype=="Complex Compound 6d") {
			r1=sqrt(sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl)+sqr(sm));
			r2=sqrt(sqr(sz)+sqr(sk)+sqr(sl)+sqr(sm));
			r3=sqrt(sqr(sk)+sqr(sl)+sqr(sm));
			r7=sqrt(sqr(sl)+sqr(sm));
			if (n<11) {
				r4=r1^n;
			} else if (n==11) {
				r4=sqr(sqr(sqr(r1)))*sqr(r1)*r1;
			} else if (n==13) {
				r4=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*r1;
			} else if (n==15) {
				r4=sqr(sqr(sqr(r1)))*sqr(sqr(r1))*sqr(r1)*r1;
			} else if (n==16) {
				r4=sqr(sqr(sqr(sqr(r1))));
			} else if (n==17) {
				r4=sqr(sqr(sqr(sqr(r1))))*r1;
			}  else {
				r4=r1^n;
			} 
			r4=r4^(-1);
			if (n<11) {
				r5=r2^n;
			} else if (n==11) {
				r5=sqr(sqr(sqr(r2)))*sqr(r2)*r2;
			} else if (n==13) {
				r5=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*r2;
			} else if (n==15) {
				r5=sqr(sqr(sqr(r2)))*sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==16) {
				r5=sqr(sqr(sqr(sqr(r2))));
			} else if (n==17) {
				r5=sqr(sqr(sqr(sqr(r2))))*r2;
			}  else {
				r5=r2^n;
			} 
			r5=r5^-1;
			if (n<11) {
				r6=r3^n;
			} else if (n==11) {
				r6=sqr(sqr(sqr(r3)))*sqr(r3)*r3;
			} else if (n==13) {
				r6=sqr(sqr(sqr(r3)))*sqr(sqr(r3))*r3;
			} else if (n==15) {
				r6=sqr(sqr(sqr(r3)))*sqr(sqr(r3))*sqr(r3)*r3;
			} else if (n==16) {
				r6=sqr(sqr(sqr(sqr(r3))));
			} else if (n==17) {
				r6=sqr(sqr(sqr(sqr(r3))))*r3;
			}  else {
				r6=r3^n;
			} 
			r6=r6^-1;
			if (n<11) {
				r8=r7^n;
			} else if (n==11) {
				r8=sqr(sqr(sqr(r7)))*sqr(r7)*r7;
			} else if (n==13) {
				r8=sqr(sqr(sqr(r7)))*sqr(sqr(r7))*r7;
			} else if (n==15) {
				r8=sqr(sqr(sqr(r7)))*sqr(sqr(r7))*sqr(r7)*r7;
			} else if (n==16) {
				r8=sqr(sqr(sqr(sqr(r7))));
			} else if (n==17) {
				r8=sqr(sqr(sqr(sqr(r7))))*r7;
			}  else {
				r8=r7^n;
			} 
			r8=r8^-1;
			
			victor=complex(sx,r1);
			bravo=complex(sy,r2);
			cramden=complex(sz,r3);
			fluffy=complex(sk,r7);
			muffin=complex(sl,sm);
			if (n<11) {
				victor=victor^n;
			} else if (n==11) {
				victor=sqr(sqr(sqr(victor)))*sqr(victor)*victor;
			} else if (n==13) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*victor;
			} else if (n==15) {
				victor=sqr(sqr(sqr(victor)))*sqr(sqr(victor))*sqr(victor)*victor;
			} else if (n==16) {
				victor=sqr(sqr(sqr(sqr(victor))));
			} else if (n==17) {
				victor=sqr(sqr(sqr(sqr(victor))))*victor;
			}  else {
				victor=victor^n;
			} 
			if (n<11) {
				bravo=bravo^n;
			} else if (n==11) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(bravo)*bravo;
			} else if (n==13) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*bravo;
			} else if (n==15) {
				bravo=sqr(sqr(sqr(bravo)))*sqr(sqr(bravo))*sqr(bravo)*bravo;
			} else if (n==16) {
				bravo=sqr(sqr(sqr(sqr(bravo))));
			} else if (n==17) {
				bravo=sqr(sqr(sqr(sqr(bravo))))*bravo;
			}  else {
				bravo=bravo^n;
			} 
			if (n<11) {
				cramden=cramden^n;
			} else if (n==11) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(cramden)*cramden;
			} else if (n==13) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*cramden;
			} else if (n==15) {
				cramden=sqr(sqr(sqr(cramden)))*sqr(sqr(cramden))*sqr(cramden)*cramden;
			} else if (n==16) {
				cramden=sqr(sqr(sqr(sqr(cramden))));
			} else if (n==17) {
				cramden=sqr(sqr(sqr(sqr(cramden))))*cramden;
			}  else {
				cramden=cramden^n;
			} 
			if (n<11) {
				fluffy=fluffy^n;
			} else if (n==11) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(fluffy)*fluffy;
			} else if (n==13) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(sqr(fluffy))*fluffy;
			} else if (n==15) {
				fluffy=sqr(sqr(sqr(fluffy)))*sqr(sqr(fluffy))*sqr(fluffy)*fluffy;
			} else if (n==16) {
				fluffy=sqr(sqr(sqr(sqr(fluffy))));
			} else if (n==17) {
				fluffy=sqr(sqr(sqr(sqr(fluffy))))*fluffy;
			}  else {
				fluffy=fluffy^n;
			} 
			if (n<11) {
				muffin=muffin^n;
			} else if (n==11) {
				muffin=sqr(sqr(sqr(muffin)))*sqr(muffin)*muffin;
			} else if (n==13) {
				muffin=sqr(sqr(sqr(muffin)))*sqr(sqr(muffin))*muffin;
			} else if (n==15) {
				muffin=sqr(sqr(sqr(muffin)))*sqr(sqr(muffin))*sqr(muffin)*muffin;
			} else if (n==16) {
				muffin=sqr(sqr(sqr(sqr(muffin))));
			} else if (n==17) {
				muffin=sqr(sqr(sqr(sqr(muffin))))*muffin;
			}  else {
				muffin=muffin^n;
			} 
			
			nx=part_r(victor);
			r=part_i(victor)*r4;
			ny=part_r(bravo)*r;
			r=part_i(bravo)*r*r5;
			nz=r*part_r(cramden);
			r=r*part_i(cramden)*r6;
			nk=r*part_r(fluffy);
			r=r*part_i(fluffy)*r8;
			nl=r*part_r(muffin);
			nm=r*part_i(muffin);
			
			if (juliaMode) {
				if (r2mode=="Normal 1") {
						sx=nx+cr;
						sy=ny+ci;
						sz=nz+cj;
						sk=nk+ck;
						sl=nl+cl;
						sm=nm+cm;
				} else if (r2mode=="Normal 2") {
						sx=nx+cr;
						sy=ny+ck;
						sz=nz+ci;
						sk=nk+cl;
						sl=nl+cj;
						sm=nm+cm;
				} else if (r2mode=="Normal 3") {
						sx=nx+ck;
						sy=ny+cl;
						sz=nz+cm;
						sk=nk+cr;
						sl=nl+ci;
						sm=nm+cj;
				} else if (r2mode=="r2 mode xyz") {
						sx=sx-nx+ck;
						sy=sy-ny+cl;
						sz=sz-nz+cm;
						sk=sk-nk+cr;
						sl=sl-nl+ci;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode xyk") {
						sx=sx-nx+ck;
						sy=sy-ny+cl;
						sz=sz-nz+cr;
						sk=sk-nk+cm;
						sl=sl-nl+ci;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode xyl") {
						sx=sx-nx+ck;
						sy=sy-ny+cl;
						sz=sz-nz+cr;
						sk=sk-nk+ci;
						sl=sl-nl+cm;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode xym") {
						sx=sx-nx+ck;
						sy=sy-ny+cl;
						sz=sz-nz+cr;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode xzk") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+cl;
						sk=sk-nk+cm;
						sl=sl-nl+ci;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode xzl") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+cl;
						sk=sk-nk+ci;
						sl=sl-nl+cm;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode xzm") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+cl;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
						sm=sm-nm+cm;
				} else if (r2mode=="r2 mode xkl") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+ci;
						sk=sk-nk+cl;
						sl=sl-nl+cm;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode xkm") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+ci;
						sk=sk-nk+cl;
						sl=sl-nl+cj;
						sm=sm-nm+cm;
				} else if (r2mode=="r2 mode xlm") {
						sx=sx-nx+ck;
						sy=sy-ny+cr;
						sz=sz-nz+ci;
						sk=sk-nk+cj;
						sl=sl-nl+cl;
						sm=sm-nm+cm;
				} else if (r2mode=="r2 mode yzk") {
						sx=sx-nx+cr;
						sy=sy-ny+ck;
						sz=sz-nz+cl;
						sk=sk-nk+cm;
						sl=sl-nl+ci;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode yzl") {
						sx=sx-nx+cr;
						sy=sy-ny+ck;
						sz=sz-nz+cl;
						sk=sk-nk+ci;
						sl=sl-nl+cm;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode yzm") {
						sx=sx-nx+cr;
						sy=sy-ny+ck;
						sz=sz-nz+cl;
						sk=sk-nk+ci;
						sl=sl-nl+cj;
						sm=sm-nm+cm;
				} else if (r2mode=="r2 mode ykl") {
						sx=sx-nx+cr;
						sy=sy-ny+ck;
						sz=sz-nz+ci;
						sk=sk-nk+cl;
						sl=sl-nl+cm;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode ykm") {
						sx=sx-nx+cr;
						sy=sy-ny+ck;
						sz=sz-nz+ci;
						sk=sk-nk+cl;
						sl=sl-nl+cj;
						sm=sm-nm+cm;
				} else if (r2mode=="r2 mode ylm") {
						sx=sx-nx+cr;
						sy=sy-ny+ck;
						sz=sz-nz+ci;
						sk=sk-nk+cj;
						sl=sl-nl+cl;
						sm=sm-nm+cm;
				} else if (r2mode=="r2 mode zkl") {
						sx=sx-nx+cr;
						sy=sy-ny+ci;
						sz=sz-nz+ck;
						sk=sk-nk+cl;
						sl=sl-nl+cm;
						sm=sm-nm+cj;
				} else if (r2mode=="r2 mode zkm") {
						sx=sx-nx+cr;
						sy=sy-ny+ci;
						sz=sz-nz+ck;
						sk=sk-nk+cl;
						sl=sl-nl+cj;
						sm=sm-nm+cm;
				} else if (r2mode=="r2 mode zlm") {
						sx=sx-nx+cr;
						sy=sy-ny+ci;
						sz=sz-nz+ck;
						sk=sk-nk+cj;
						sl=sl-nl+cl;
						sm=sm-nm+cm;
				} else if (r2mode=="r2 mode klm") {
						sx=sx-nx+cr;
						sy=sy-ny+ci;
						sz=sz-nz+cj;
						sk=sk-nk+ck;
						sl=sl-nl+cl;
						sm=sm-nm+cm;
				}
			} else {
				if (r2mode=="r2 mode xyz") {
				     if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+pixell*iterinv;
						sz=-nz+sz+pixelm*iterinv;
						sk=-nk+sk+pixelr*iterinv;
						sl=-nl+sl+pixeli*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+pixell*iterinv;
						sz=nz+sz+pixelm*iterinv;
						sk=nk+sk+pixelr*iterinv;
						sl=nl+sl+pixeli*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+sy+pixell;
						sz=nz+sz+pixelm;
						sk=nk+pixelr;
						sl=nl+pixeli;
						sm=nm+pixelj;
					}
				} else if (r2mode=="Normal 1") {
						sx=nx+(pixelr);
						sy=ny+(pixeli);
						sz=nz+(pixelj);
						sk=nk+(pixelk);
						sl=nl+pixell;
						sm=nm+pixelm;
				} else if (r2mode=="r2 mode xyk") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+(pixell)*iterinv;
						sz=-nz+sz+(pixelr)*iterinv;
						sk=-nk+sk+(pixelm)*iterinv;
						sl=-nl+sl+pixeli*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+(pixell)*iterinv;
						sz=nz+sz+(pixelr)*iterinv;
						sk=nk+sk+(pixelm)*iterinv;
						sl=nl+sl+pixeli*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+sy+pixell;
						sz=nz+pixelr;
						sk=nk+sk+pixelm;
						sl=nl+pixeli;
						sm=nm+pixelj;
					}
				} else if (r2mode=="r2 mode xyl") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+pixell*iterinv;
						sz=-nz+sz+pixelr*iterinv;
						sk=-nk+sk+pixeli*iterinv;
						sl=-nl+sl+pixelm*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+pixell*iterinv;
						sz=nz+sz+pixelr*iterinv;
						sk=nk+sk+pixeli*iterinv;
						sl=nl+sl+pixelm*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+sy+pixell;
						sz=nz+pixelr;
						sk=nk+pixeli;
						sl=nl+sl+pixelm;
						sm=nm+pixelj;
					}
				}  else if (r2mode=="r2 mode xym") {
						if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+pixell*iterinv;
						sz=-nz+sz+pixelr*iterinv;
						sk=-nk+sk+pixeli*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+pixell*iterinv;
						sz=nz+sz+pixelr*iterinv;
						sk=nk+sk+pixeli*iterinv;
						sl=nl+sl+pixelj*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+sy+pixell;
						sz=nz+pixelr;
						sk=nk+pixeli;
						sl=nl+pixelj;
						sm=nm+sm+pixelm;
					}
				} else if (r2mode=="r2 mode xzk") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+pixelr*iterinv;
						sz=-nz+sz+pixell*iterinv;
						sk=-nk+sk+pixelm*iterinv;
						sl=-nl+sl+pixeli*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+pixelr*iterinv;
						sz=nz+sz+pixell*iterinv;
						sk=nk+sk+pixelm*iterinv;
						sl=nl+sl+pixeli*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+pixelr;
						sz=nz+sz+pixell;
						sk=nk+sk+pixelm;
						sl=nl+pixeli;
						sm=nm+pixelj;
					}
				}  else if (r2mode=="r2 mode xzl") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+pixelr*iterinv;
						sz=-nz+sz+pixell*iterinv;
						sk=-nk+sk+pixeli*iterinv;
						sl=-nl+sl+pixelm*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+pixelr*iterinv;
						sz=nz+sz+pixell*iterinv;
						sk=nk+sk+pixeli*iterinv;
						sl=nl+sl+pixelm*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+pixelr;
						sz=nz+sz+pixell;
						sk=nk+pixeli;
						sl=nl+sl+pixelm;
						sm=nm+pixelj;
					}
				} else if (r2mode=="r2 mode xzm") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+pixelr*iterinv;
						sz=-nz+sz+pixell*iterinv;
						sk=-nk+sk+pixeli*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+pixelr*iterinv;
						sz=nz+sz+pixell*iterinv;
						sk=nk+sk+pixeli*iterinv;
						sl=nl+sl+pixelj*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+pixelr;
						sz=nz+sz+pixell;
						sk=nk+pixeli;
						sl=nl+pixelj;
						sm=nm+sm+pixelm;
					}
				} else if (r2mode=="r2 mode xkl") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+pixelr*iterinv;
						sz=-nz+sz+pixeli*iterinv;
						sk=-nk+sk+pixell*iterinv;
						sl=-nl+sl+pixelm*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+pixelr*iterinv;
						sz=nz+sz+pixeli*iterinv;
						sk=nk+sk+pixell*iterinv;
						sl=nl+sl+pixelm*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+pixelr;
						sz=nz+pixeli;
						sk=nk+sk+pixell;
						sl=nl+sl+pixelm;
						sm=nm+pixelj;
					}
				} else if (r2mode=="r2 mode xkm") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+pixelr*iterinv;
						sz=-nz+sz+pixeli*iterinv;
						sk=-nk+sk+pixell*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+pixelr*iterinv;
						sz=nz+sz+pixeli*iterinv;
						sk=nk+sk+pixell*iterinv;
						sl=nl+sl+pixelj*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+pixelr;
						sz=nz+pixeli;
						sk=nk+sk+pixell;
						sl=nl+pixelj;
						sm=nm+sm+pixelm;
					}
				} else if (r2mode=="r2 mode xlm") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelk*iterinv;
						sy=-ny+sy+pixelr*iterinv;
						sz=-nz+sz+pixeli*iterinv;
						sk=-nk+sk+pixelj*iterinv;
						sl=-nl+sl+pixell*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelk*iterinv;
						sy=ny+sy+pixelr*iterinv;
						sz=nz+sz+pixeli*iterinv;
						sk=nk+sk+pixelj*iterinv;
						sl=nl+sl+pixell*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+sx+pixelk;
						sy=ny+pixelr;
						sz=nz+pixeli;
						sk=nk+pixelj;
						sl=nl+sl+pixell;
						sm=nm+sm+pixelm;
					}
				} else if (r2mode=="r2 mode yzk") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixelk*iterinv;
						sz=-nz+sz+pixell*iterinv;
						sk=-nk+sk+pixelm*iterinv;
						sl=-nl+sl+pixeli*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixelk*iterinv;
						sz=nz+sz+pixell*iterinv;
						sk=nk+sk+pixelm*iterinv;
						sl=nl+sl+pixeli*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+sy+pixelk;
						sz=nz+sz+pixell;
						sk=nk+sk+pixelm;
						sl=nl+pixeli;
						sm=nm+pixelj;
					}
				} else if (r2mode=="r2 mode yzl") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixelk*iterinv;
						sz=-nz+sz+pixell*iterinv;
						sk=-nk+sk+pixeli*iterinv;
						sl=-nl+sl+pixelm*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixelk*iterinv;
						sz=nz+sz+pixell*iterinv;
						sk=nk+sk+pixeli*iterinv;
						sl=nl+sl+pixelm*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+sy+pixelk;
						sz=nz+sz+pixell;
						sk=nk+pixeli;
						sl=nl+sl+pixelm;
						sm=nm+pixelj;
					}
				} else if (r2mode=="r2 mode yzm") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixelk*iterinv;
						sz=-nz+sz+pixell*iterinv;
						sk=-nk+sk+pixeli*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixelk*iterinv;
						sz=nz+sz+pixell*iterinv;
						sk=nk+sk+pixeli*iterinv;
						sl=nl+sl+pixelj*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+sy+pixelk;
						sz=nz+sz+pixell;
						sk=nk+pixeli;
						sl=nl+pixelj;
						sm=nm+sm+pixelm;
					}
				} else if (r2mode=="r2 mode ykl") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixelk*iterinv;
						sz=-nz+sz+pixeli*iterinv;
						sk=-nk+sk+pixell*iterinv;
						sl=-nl+sl+pixelm*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixelk*iterinv;
						sz=nz+sz+pixeli*iterinv;
						sk=nk+sk+pixell*iterinv;
						sl=nl+sl+pixelm*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+sy+pixelk;
						sz=nz+pixeli;
						sk=nk+sk+pixell;
						sl=nl+sl+pixelm;
						sm=nm+pixelj;
					}
				} else if (r2mode=="r2 mode ykm") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixelk*iterinv;
						sz=-nz+sz+pixeli*iterinv;
						sk=-nk+sk+pixell*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixelk*iterinv;
						sz=nz+sz+pixeli*iterinv;
						sk=nk+sk+pixell*iterinv;
						sl=nl+sl+pixelj*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+sy+pixelk;
						sz=nz+pixeli;
						sk=nk+sk+pixell;
						sl=nl+pixelj;
						sm=nm+sm+pixelm;
					}
				} else if (r2mode=="r2 mode ylm") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixelk*iterinv;
						sz=-nz+sz+pixeli*iterinv;
						sk=-nk+sk+pixelj*iterinv;
						sl=-nl+sl+pixell*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixelk*iterinv;
						sz=nz+sz+pixeli*iterinv;
						sk=nk+sk+pixelj*iterinv;
						sl=nl+sl+pixell*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+sy+pixelk;
						sz=nz+pixeli;
						sk=nk+pixelj;
						sl=nl+sl+pixell;
						sm=nm+sm+pixelm;
					}
				} else if (r2mode=="r2 mode zkl") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixeli*iterinv;
						sz=-nz+sz+pixelk*iterinv;
						sk=-nk+sk+pixell*iterinv;
						sl=-nl+sl+pixelm*iterinv;
						sm=-nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixeli*iterinv;
						sz=nz+sz+pixelk*iterinv;
						sk=nk+sk+pixell*iterinv;
						sl=nl+sl+pixelm*iterinv;
						sm=nm+sm+pixelj*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+pixeli;
						sz=nz+sz+pixelk;
						sk=nk+sk+pixell;
						sl=nl+sl+pixelm;
						sm=nm+pixelj;
					}
				} else if (r2mode=="r2 mode zkm") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixeli*iterinv;
						sz=-nz+sz+pixelk*iterinv;
						sk=-nk+sk+pixell*iterinv;
						sl=-nl+sl+pixelj*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixeli*iterinv;
						sz=nz+sz+pixelk*iterinv;
						sk=nk+sk+pixell*iterinv;
						sl=nl+sl+pixelj*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+pixeli;
						sz=nz+sz+pixelk;
						sk=nk+sk+pixell;
						sl=nl+pixelj;
						sm=nm+sm+pixelm;
					}
				} else if (r2mode=="r2 mode zlm") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixeli*iterinv;
						sz=-nz+sz+pixelk*iterinv;
						sk=-nk+sk+pixelj*iterinv;
						sl=-nl+sl+pixell*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixeli*iterinv;
						sz=nz+sz+pixelk*iterinv;
						sk=nk+sk+pixelj*iterinv;
						sl=nl+sl+pixell*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+pixeli;
						sz=nz+sz+pixelk;
						sk=nl+pixelj;
						sl=nk+sl+pixell;
						sm=nm+sm+pixelm;
					}
				} else if (r2mode=="r2 mode klm") {
					if (r2modeB=="- new") {
					     iterinv=count^-countexp;
					  	sx=-nx+sx+pixelr*iterinv;
						sy=-ny+sy+pixeli*iterinv;
						sz=-nz+sz+pixelj*iterinv;
						sk=-nk+sk+pixelk*iterinv;
						sl=-nl+sl+pixell*iterinv;
						sm=-nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="+ new") {
						iterinv=count^-countexp;
					  	sx=nx+sx+pixelr*iterinv;
						sy=ny+sy+pixeli*iterinv;
						sz=nz+sz+pixelj*iterinv;
						sk=nk+sk+pixelk*iterinv;
						sl=nl+sl+pixell*iterinv;
						sm=nm+sm+pixelm*iterinv;
						if (increments<countincrements) {
							count=count+countincrement;
							increments=increments+1;
						}	
					} else if (r2modeB=="none") {
						sx=nx+pixelr;
						sy=ny+pixeli;
						sz=nz+pixelj;
						sk=nk+sk+pixelk;
						sl=nl+sl+pixell;
						sm=nm+sm+pixelm;
					}
				}  else if (r2mode=="Normal 2") {
						sx=nx+(pixelr);
						sy=ny+(pixelk);
						sz=nz+(pixeli);
						sk=nk+(pixell);
						sl=nl+pixelj;
						sm=nm+pixelj;
				} else if (r2mode=="Normal 3") {
						sx=nx+(pixelk);
						sy=ny+(pixell);
						sz=nz+(pixelm);
						sk=nk+(pixelr);
						sl=nl+pixeli;
						sm=nm+pixelj;
				}
			}
			if (colormode=="Complex Real V") {
				z=quaternion(real(victor),real(bravo),real(cramden),real(fluffy));
			} else if (colormode=="Complex Real M") {
				z=quaternion(real(bravo),real(cramden),real(fluffy),real(muffin));
			} else if (colormode=="xyzk") {
				z=quaternion(sx,sy,sz,sk);
			} else if (colormode=="xy zk l m") {
				z=quaternion(sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sl,sm);
			} else if (colormode=="xl ym z k") {
				z=quaternion(sqrt(sqr(sx)+sqr(sl)),sqrt(sqr(sy)+sqr(sm)),sz,sk);
			} else if (colormode=="x y zk lm") {
				z=quaternion(sx,sy,sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
			} else if (colormode=="y k xl zm") {
				z=quaternion(sy,sk,sqrt(sqr(sx)+sqr(sl)),sqrt(sqr(sz)+sqr(sm)));
			} else if (colormode=="nxyzk") {
				z=quaternion(nx,ny,nz,nk);
			} else if (colormode=="xyzl") {
				z=quaternion(sx,sy,sz,sl);
			} else if (colormode=="nxyzl") {
				z=quaternion(nx,ny,nz,nl);
			} else if (colormode=="xyzm") {
				z=quaternion(sx,sy,sz,sm);
			} else if (colormode=="nxyzm") {
				z=quaternion(nx,ny,nz,nm);
			} else if (colormode=="xykl") {
				z=quaternion(sx,sy,sk,sl);
			} else if (colormode=="nxykl") {
				z=quaternion(nx,ny,nk,nl);
			} else if (colormode=="xykm") {
				z=quaternion(sx,sy,sk,sm);
			} else if (colormode=="nxykm") {
				z=quaternion(nx,ny,nk,nm);
			} else if (colormode=="xylm") {
				z=quaternion(sx,sy,sl,sm);
			} else if (colormode=="nxylm") {
				z=quaternion(nx,ny,nl,nm);
			} else if (colormode=="xzkl") {
				z=quaternion(sx,sz,sk,sl);
			} else if (colormode=="nxzkl") {
				z=quaternion(nx,nz,nk,nl);
			} else if (colormode=="xzkm") {
				z=quaternion(sx,sz,sk,sm);
			} else if (colormode=="nxzkm") {
				z=quaternion(nx,nz,nk,nm);
			} else if (colormode=="xzlm") {
				z=quaternion(sx,sz,sl,sm);
			} else if (colormode=="nxzlm") {
				z=quaternion(nx,nz,nl,nm);
			} else if (colormode=="xklm") {
				z=quaternion(sx,sk,sl,sm);
			} else if (colormode=="nxklm") {
				z=quaternion(nx,nk,nl,nm);
			} else if (colormode=="yzkl") {
				z=quaternion(sy,sz,sk,sl);
			} else if (colormode=="nyzkl") {
				z=quaternion(ny,nz,nk,nl);
			} else if (colormode=="yzkm") {
				z=quaternion(sy,sz,sk,sm);
			} else if (colormode=="nyzkm") {
				z=quaternion(ny,nz,nk,nm);
			} else if (colormode=="yzlm") {
				z=quaternion(sy,sz,sl,sm);
			} else if (colormode=="nyzlm") {
				z=quaternion(ny,nz,nl,nm);
			} else if (colormode=="yklm") {
				z=quaternion(sy,sk,sl,sm);
			} else if (colormode=="nyklm") {
				z=quaternion(ny,nk,nl,nm);
			} else if (colormode=="zklm") {
				z=quaternion(sz,sk,sl,sm);
			} else if (colormode=="nzklm") {
				z=quaternion(nz,nk,nl,nm);
			} else if (colormode=="Complex Mag (wrong)") {
				z=quaternion(cabs(victor),cabs(bravo),cabs(cramden),cabs(fluffy));
			} else if (colormode=="Complex Imag V") {
				z=quaternion(imag(victor),imag(bravo),imag(cramden),imag(fluffy));
			} else if (colormode=="Complex Imag M") {
				z=quaternion(imag(bravo),imag(cramden),imag(fluffy),imag(muffin));
			} else if (colormode=="Mag, x, y, z") {
				r=sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl)+sqr(sm));
				if (r2mode=="Normal 1") {
					z=quaternion(r,sx,sy,sz);
				} else if (r2mode=="Normal 2") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="Normal 3") {
					z=quaternion(r,sk,sl,sm);
				} else if (r2mode=="r2 mode xyz") {
					z=quaternion(r,sk,sl,sm);
				} else if (r2mode=="r2 mode xyk") {
					z=quaternion(r,sz,sl,sm);
				} else if (r2mode=="r2 mode xyl") {
					z=quaternion(r,sz,sk,sm);
				} else if (r2mode=="r2 mode xym") {
					z=quaternion(r,sz,sk,sl);
				} else if (r2mode=="r2 mode xzk") {
					z=quaternion(r,sy,sl,sm);
				} else if (r2mode=="r2 mode xzl") {
					z=quaternion(r,sy,sk,sm);
				} else if (r2mode=="r2 mode xzm") {
					z=quaternion(r,sy,sk,sl);
				} else if (r2mode=="r2 mode xkl") {
					z=quaternion(r,sy,sz,sm);
				} else if (r2mode=="r2 mode xkm") {
					z=quaternion(r,sy,sz,sl);
				} else if (r2mode=="r2 mode xlm") {
					z=quaternion(r,sy,sz,sk);
				} else if (r2mode=="r2 mode yzk") {
					z=quaternion(r,sx,sl,sm);
				} else if (r2mode=="r2 mode yzl") {
					z=quaternion(r,sx,sk,sm);
				} else if (r2mode=="r2 mode yzm") {
					z=quaternion(r,sx,sk,sl);
				} else if (r2mode=="r2 mode ykl") {
					z=quaternion(r,sx,sz,sm);
				} else if (r2mode=="r2 mode ykm") {
					z=quaternion(r,sx,sz,sl);
				} else if (r2mode=="r2 mode ylm") {
					z=quaternion(r,sx,sz,sk);
				} else if (r2mode=="r2 mode zkl") {
					z=quaternion(r,sx,sy,sm);
				} else if (r2mode=="r2 mode zkm") {
					z=quaternion(r,sx,sy,sl);
				} else if (r2mode=="r2 mode zlm") {
					z=quaternion(r,sx,sy,sk);
				} else if (r2mode=="r2 mode klm") {
					z=quaternion(r,sx,sy,sz);
				}
			}  else if (colormode=="Mag, xk, yl, zm") {
				if (r2mode=="Normal 1") {
					r=sqrt(sqr(sk)+sqr(sl)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sk)),sqrt(sqr(sy)+sqr(sl)),sqrt(sqr(sz)+sqr(sm)));
				} else if (r2mode=="Normal 2") {
					r=sqrt(sqr(sy)+sqr(sk)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="Normal 3") {
					r=sqrt(sqr(sk)+sqr(sl)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sk)),sqrt(sqr(sy)+sqr(sl)),sqrt(sqr(sz)+sqr(sm)));
				} else if (r2mode=="r2 mode xyz") {
					r=sqrt(sqr(sk)+sqr(sl)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sk)),sqrt(sqr(sy)+sqr(sl)),sqrt(sqr(sz)+sqr(sm)));
				} else if (r2mode=="r2 mode xyk") {
					r=sqrt(sqr(sz)+sqr(sl)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sz)),sqrt(sqr(sy)+sqr(sl)),sqrt(sqr(sk)+sqr(sm)));
				} else if (r2mode=="r2 mode xyl") {
					r=sqrt(sqr(sz)+sqr(sk)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sz)),sqrt(sqr(sy)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode xym") {
					r=sqrt(sqr(sz)+sqr(sk)+sqr(sl));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sz)),sqrt(sqr(sy)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode xzk") {
					r=sqrt(sqr(sy)+sqr(sl)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sl)),sqrt(sqr(sk)+sqr(sm)));
				} else if (r2mode=="r2 mode xzl") {
					r=sqrt(sqr(sy)+sqr(sk)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode xzm") {
					r=sqrt(sqr(sy)+sqr(sk)+sqr(sl));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode xkl") {
					r=sqrt(sqr(sy)+sqr(sz)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode xkm") {
					r=sqrt(sqr(sy)+sqr(sz)+sqr(sl));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode xlm") {
					r=sqrt(sqr(sy)+sqr(sz)+sqr(sk));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sl)),sqrt(sqr(sk)+sqr(sm)));
				} else if (r2mode=="r2 mode yzk") {
					r=sqrt(sqr(sx)+sqr(sl)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sl)),sqrt(sqr(sk)+sqr(sm)));
				} else if (r2mode=="r2 mode yzl") {
					r=sqrt(sqr(sx)+sqr(sk)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode yzm") {
					r=sqrt(sqr(sx)+sqr(sk)+sqr(sl));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode ykl") {
					r=sqrt(sqr(sx)+sqr(sz)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode ykm") {
					r=sqrt(sqr(sx)+sqr(sz)+sqr(sl));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode ylm") {
					r=sqrt(sqr(sx)+sqr(sz)+sqr(sk));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sy)),sqrt(sqr(sz)+sqr(sl)),sqrt(sqr(sk)+sqr(sm)));
				} else if (r2mode=="r2 mode zkl") {
					r=sqrt(sqr(sx)+sqr(sy)+sqr(sm));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sz)),sqrt(sqr(sy)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode zkm") {
					r=sqrt(sqr(sx)+sqr(sy)+sqr(sl));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sz)),sqrt(sqr(sy)+sqr(sk)),sqrt(sqr(sl)+sqr(sm)));
				} else if (r2mode=="r2 mode zlm") {
					r=sqrt(sqr(sx)+sqr(sy)+sqr(sk));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sz)),sqrt(sqr(sy)+sqr(sl)),sqrt(sqr(sk)+sqr(sm)));
				} else if (r2mode=="r2 mode klm") {
					r=sqrt(sqr(sx)+sqr(sy)+sqr(sz));
					z=quaternion(r,sqrt(sqr(sx)+sqr(sk)),sqrt(sqr(sy)+sqr(sl)),sqrt(sqr(sz)+sqr(sm)));
				}
			} else if (colormode=="Mag, nx,ny,nz") {
				r=sqrt(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk)+sqr(sl)+sqr(sm));
				if (r2mode=="Normal 1") {
					z=quaternion(r,nx,ny,nz);
				} else if (r2mode=="Normal 2") {
					z=quaternion(r,nx,nz,nl);
				} else if (r2mode=="Normal 3") {
					z=quaternion(r,nk,nl,nm);
				} else if (r2mode=="r2 mode xyz") {
					z=quaternion(r,nk,nl,nm);
				} else if (r2mode=="r2 mode xyk") {
					z=quaternion(r,nz,nl,nm);
				} else if (r2mode=="r2 mode xyl") {
					z=quaternion(r,nz,nk,nm);
				} else if (r2mode=="r2 mode xym") {
					z=quaternion(r,nz,nk,nl);
				} else if (r2mode=="r2 mode xzk") {
					z=quaternion(r,ny,nl,nm);
				} else if (r2mode=="r2 mode xzl") {
					z=quaternion(r,ny,nk,nm);
				} else if (r2mode=="r2 mode xzm") {
					z=quaternion(r,ny,nk,nl);
				} else if (r2mode=="r2 mode xkl") {
					z=quaternion(r,ny,nz,nm);
				} else if (r2mode=="r2 mode xkm") {
					z=quaternion(r,ny,nz,nl);
				} else if (r2mode=="r2 mode xlm") {
					z=quaternion(r,ny,nz,nk);
				} else if (r2mode=="r2 mode yzk") {
					z=quaternion(r,nx,nl,nm);
				} else if (r2mode=="r2 mode yzl") {
					z=quaternion(r,nx,nk,nm);
				} else if (r2mode=="r2 mode yzm") {
					z=quaternion(r,nx,nk,nl);
				} else if (r2mode=="r2 mode ykl") {
					z=quaternion(r,nx,nz,nm);
				} else if (r2mode=="r2 mode ykm") {
					z=quaternion(r,nx,nz,nl);
				} else if (r2mode=="r2 mode ylm") {
					z=quaternion(r,nx,nz,nk);
				} else if (r2mode=="r2 mode zkl") {
					z=quaternion(r,nx,ny,nm);
				} else if (r2mode=="r2 mode zkm") {
					z=quaternion(r,nx,ny,nl);
				} else if (r2mode=="r2 mode zlm") {
					z=quaternion(r,nx,ny,nk);
				} else if (r2mode=="r2 mode klm") {
					z=quaternion(r,nx,ny,nz);
				}
			}
			
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk)+abs(sl)+abs(sm);
			
		}
		else if (fractaltype=="Mandelbrot 5d") {
			r2=(sqr(sx)+sqr(sy)+sqr(sz)+sqr(sk))^(n/2);
			
			if (r2mode) {
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz)+sqr(sk))));		
				phi=atan2((sy)+flip(sqrt(sqr(sz)+sqr(sk))));
				tango= atan2((sz)+flip((sk)));
			} else {
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz)+sqr(sk))));		
				phi=atan2(abs(sy)+flip(sqrt(sqr(sz)+sqr(sk))));
				tango= atan2(abs(sz)+flip(abs(sk)));
			}
			nx=r2*cos(theta*n);
			ny=r2*sin(theta*n)*cos(phi*n);
			nz=r2*sin(theta*n)*sin(phi*n)*cos(tango*n);
			nk=r2*sin(theta*n)*sin(phi*n)*sin(tango*n);
				
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sz=nk+ck;
			} else {
				sx=nx+(pixelr);
				sy=ny+abs(pixeli);
				sz=nz+abs(pixelj);
				sk=nk+abs(pixelk);
			}
			z=quaternion(sk,sx,sy,sz);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			bail=abs(sx)+abs(sy)+abs(sz)+abs(sk);
		}
	 
	}

	bool bailout(void)
	{
		return(bail<bailout);
	}
	
	void description(void)
	{
		this.title="6 D Benesi Set";
		bailout.caption = "Bailout Value";
		bailout.default = 16;
		bailout.min = 0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.  Set high for these fractals as it smooths them out.";
		
		fractaltype.caption="Formula";
		fractaltype.enum="Complex Compound 6d\nMandelbrot 5d";
		fractaltype.default=0;
		fractaltype.hint="If you select Mandala, MAKE SURE TO ROTATE THE FRACTAL EITHER HORIZONTALLY OR VERTICALLY BY 45 DEGREES";
			
		assignment.caption="P.V.A. Mode";
		assignment.enum="Magnitude\n-Magnitude\nLinear Sign Magnitude\nPlanar Sign Magnitude\nComplexitude\n-Complexitude\nLinear Sign Complexitude\nPlanar Sign Complexitude";
		assignment.default=0;
		assignment.hint="Planar variable assignment moded lets you specify how planar variables w, v, and u are assigned.  Leave on magnitude or -magnitude mode for most calculations, play around with complexitude modes for more complicated, albeit somewhat mismatched images";
		
		timemode.caption="Time Mode";
		timemode.enum="Normal\nTotal Mag\n-Total Mag\nSpecial 1\nSpecial 2\n-Special 2";
		timemode.default=0;
		
		r2mode.caption="R2 Mode";
		r2mode.enum="Normal 1\nr2 mode xyz\nr2 mode xyk\nr2 mode xyl\nr2 mode xym\nr2 mode xzk\nr2 mode xzl\nr2 mode xzm\nr2 mode xkl\nr2 mode xkm\nr2 mode xlm\nr2 mode yzk\nr2 mode yzl\nr2 mode yzm\nr2 mode ykl\nr2 mode ykm\nr2 mode ylm\nr2 mode zkl\nr2 mode zkm\nr2 mode zlm\nr2 mode klm\nNormal 2\nNormal 3";
		r2modeB.caption="R2 Mode B";
		r2modeB.enum="none\n+ new\n- new";
		
		colormode.caption="Color Mode";
		colormode.enum="Mag, x, y, z\nxyzk\nxyzl\nxyzm\nxykl\nxykm\nxylm\nxzkl\nxzkm\nxzlm\nxklm\nyzkl\nyzkm\nyzlm\nyklm\nzklm\nnxyzk\nnxyzl\nnxyzm\nnxykl\nnxykm\nnxylm\nnxzkl\nnxzkm\nnxzlm\nnxklm\nnyzkm\nnyzkl\nnyzlm\nnyklm\nnzklm\nMag, xk, yl, zm\nxy zk l m\nxl ym z k\nx y zk lm\ny k xl zm\nComplex Real V\nComplex Real M\nComplex Mag (wrong)\nMag, nx,ny,nz\nMag,nxk,nyl,nzm\nComplex Imag V\nComplex Imag M";
		
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		
		n.caption="n";
		n.default=2;
		n.hint="z^n.  n is the angular multiplier (rotation) and magnitude applied to the fractal formula.";
		
	
		c.caption="c";
		c.default=(0,0,0,0); /*(0.3,-0.44,-0.57,0.3); */
		c.hint="for Julia fractals set values 1,2 and 3 of this and c2";
		partcl.caption="c (part 5):";
		partcm.caption="c (part 6):";
		c2.caption="part k c2:";
		c2.default=0;
		c2.hint="change part_k c to c2 for older fractals";
		c3.caption="part l c3:";
		c4.caption="part m c4:";
		
		countstart.caption="Count Start:";
		countstart.default=1;
		countstart.hint="Starting number to divide pixel values by for r2modeB fractal varieties";
		countincrements.caption="# of Counts";
		countincrements.default=33;
		countincrements.hint="Number of times to increase count value by count increment, for 5 iterations of count increase, use a value of 5";
		countincrement.caption="Count +:";
		countincrement.default=1;
		countincrement.hint="Increments count by a specific number each iteration.";
		countexp.caption="Count ^-n:";
		countexp.default=2;
		countexp.hint="For pixel/Count set to 1.  For pixel/count^2 set to 2... etc.";
		
		
		}
}
